package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SchedulerBuilder extends SchedulerFluentImpl<SchedulerBuilder> implements VisitableBuilder<Scheduler,SchedulerBuilder>{
  public SchedulerBuilder() {
    this(false);
  }
  public SchedulerBuilder(Boolean validationEnabled) {
    this(new Scheduler(), validationEnabled);
  }
  public SchedulerBuilder(SchedulerFluent<?> fluent) {
    this(fluent, false);
  }
  public SchedulerBuilder(SchedulerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Scheduler(), validationEnabled);
  }
  public SchedulerBuilder(SchedulerFluent<?> fluent,Scheduler instance) {
    this(fluent, instance, false);
  }
  public SchedulerBuilder(SchedulerFluent<?> fluent,Scheduler instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SchedulerBuilder(Scheduler instance) {
    this(instance,false);
  }
  public SchedulerBuilder(Scheduler instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SchedulerFluent<?> fluent;
  Boolean validationEnabled;
  public Scheduler build() {
    Scheduler buildable = new Scheduler(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}