package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RequestHeaderIdentityProviderBuilder extends RequestHeaderIdentityProviderFluentImpl<RequestHeaderIdentityProviderBuilder> implements VisitableBuilder<RequestHeaderIdentityProvider,RequestHeaderIdentityProviderBuilder>{
  public RequestHeaderIdentityProviderBuilder() {
    this(false);
  }
  public RequestHeaderIdentityProviderBuilder(Boolean validationEnabled) {
    this(new RequestHeaderIdentityProvider(), validationEnabled);
  }
  public RequestHeaderIdentityProviderBuilder(RequestHeaderIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public RequestHeaderIdentityProviderBuilder(RequestHeaderIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RequestHeaderIdentityProvider(), validationEnabled);
  }
  public RequestHeaderIdentityProviderBuilder(RequestHeaderIdentityProviderFluent<?> fluent,RequestHeaderIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public RequestHeaderIdentityProviderBuilder(RequestHeaderIdentityProviderFluent<?> fluent,RequestHeaderIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCa(instance.getCa());
      fluent.withChallengeURL(instance.getChallengeURL());
      fluent.withClientCommonNames(instance.getClientCommonNames());
      fluent.withEmailHeaders(instance.getEmailHeaders());
      fluent.withHeaders(instance.getHeaders());
      fluent.withLoginURL(instance.getLoginURL());
      fluent.withNameHeaders(instance.getNameHeaders());
      fluent.withPreferredUsernameHeaders(instance.getPreferredUsernameHeaders());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RequestHeaderIdentityProviderBuilder(RequestHeaderIdentityProvider instance) {
    this(instance,false);
  }
  public RequestHeaderIdentityProviderBuilder(RequestHeaderIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCa(instance.getCa());
      this.withChallengeURL(instance.getChallengeURL());
      this.withClientCommonNames(instance.getClientCommonNames());
      this.withEmailHeaders(instance.getEmailHeaders());
      this.withHeaders(instance.getHeaders());
      this.withLoginURL(instance.getLoginURL());
      this.withNameHeaders(instance.getNameHeaders());
      this.withPreferredUsernameHeaders(instance.getPreferredUsernameHeaders());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RequestHeaderIdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public RequestHeaderIdentityProvider build() {
    RequestHeaderIdentityProvider buildable = new RequestHeaderIdentityProvider(fluent.getCa(),fluent.getChallengeURL(),fluent.getClientCommonNames(),fluent.getEmailHeaders(),fluent.getHeaders(),fluent.getLoginURL(),fluent.getNameHeaders(),fluent.getPreferredUsernameHeaders());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}