package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReleaseBuilder extends ReleaseFluentImpl<ReleaseBuilder> implements VisitableBuilder<Release,ReleaseBuilder>{
  public ReleaseBuilder() {
    this(false);
  }
  public ReleaseBuilder(Boolean validationEnabled) {
    this(new Release(), validationEnabled);
  }
  public ReleaseBuilder(ReleaseFluent<?> fluent) {
    this(fluent, false);
  }
  public ReleaseBuilder(ReleaseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Release(), validationEnabled);
  }
  public ReleaseBuilder(ReleaseFluent<?> fluent,Release instance) {
    this(fluent, instance, false);
  }
  public ReleaseBuilder(ReleaseFluent<?> fluent,Release instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withChannels(instance.getChannels());
      fluent.withImage(instance.getImage());
      fluent.withUrl(instance.getUrl());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReleaseBuilder(Release instance) {
    this(instance,false);
  }
  public ReleaseBuilder(Release instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withChannels(instance.getChannels());
      this.withImage(instance.getImage());
      this.withUrl(instance.getUrl());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReleaseFluent<?> fluent;
  Boolean validationEnabled;
  public Release build() {
    Release buildable = new Release(fluent.getChannels(),fluent.getImage(),fluent.getUrl(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}