package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProxySpecFluentImpl<A extends ProxySpecFluent<A>> extends BaseFluent<A> implements ProxySpecFluent<A>{
  public ProxySpecFluentImpl() {
  }
  public ProxySpecFluentImpl(ProxySpec instance) {
    if (instance != null) {
      this.withHttpProxy(instance.getHttpProxy());
      this.withHttpsProxy(instance.getHttpsProxy());
      this.withNoProxy(instance.getNoProxy());
      this.withReadinessEndpoints(instance.getReadinessEndpoints());
      this.withTrustedCA(instance.getTrustedCA());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String httpProxy;
  private String httpsProxy;
  private String noProxy;
  private List<String> readinessEndpoints = new ArrayList<String>();
  private ConfigMapNameReferenceBuilder trustedCA;
  private Map<String,Object> additionalProperties;
  public String getHttpProxy() {
    return this.httpProxy;
  }
  public A withHttpProxy(String httpProxy) {
    this.httpProxy=httpProxy; return (A) this;
  }
  public Boolean hasHttpProxy() {
    return this.httpProxy != null;
  }
  public String getHttpsProxy() {
    return this.httpsProxy;
  }
  public A withHttpsProxy(String httpsProxy) {
    this.httpsProxy=httpsProxy; return (A) this;
  }
  public Boolean hasHttpsProxy() {
    return this.httpsProxy != null;
  }
  public String getNoProxy() {
    return this.noProxy;
  }
  public A withNoProxy(String noProxy) {
    this.noProxy=noProxy; return (A) this;
  }
  public Boolean hasNoProxy() {
    return this.noProxy != null;
  }
  public A addToReadinessEndpoints(int index,String item) {
    if (this.readinessEndpoints == null) {this.readinessEndpoints = new ArrayList<String>();}
    this.readinessEndpoints.add(index, item);
    return (A)this;
  }
  public A setToReadinessEndpoints(int index,String item) {
    if (this.readinessEndpoints == null) {this.readinessEndpoints = new ArrayList<String>();}
    this.readinessEndpoints.set(index, item); return (A)this;
  }
  public A addToReadinessEndpoints(java.lang.String... items) {
    if (this.readinessEndpoints == null) {this.readinessEndpoints = new ArrayList<String>();}
    for (String item : items) {this.readinessEndpoints.add(item);} return (A)this;
  }
  public A addAllToReadinessEndpoints(Collection<String> items) {
    if (this.readinessEndpoints == null) {this.readinessEndpoints = new ArrayList<String>();}
    for (String item : items) {this.readinessEndpoints.add(item);} return (A)this;
  }
  public A removeFromReadinessEndpoints(java.lang.String... items) {
    for (String item : items) {if (this.readinessEndpoints!= null){ this.readinessEndpoints.remove(item);}} return (A)this;
  }
  public A removeAllFromReadinessEndpoints(Collection<String> items) {
    for (String item : items) {if (this.readinessEndpoints!= null){ this.readinessEndpoints.remove(item);}} return (A)this;
  }
  public List<String> getReadinessEndpoints() {
    return this.readinessEndpoints;
  }
  public String getReadinessEndpoint(int index) {
    return this.readinessEndpoints.get(index);
  }
  public String getFirstReadinessEndpoint() {
    return this.readinessEndpoints.get(0);
  }
  public String getLastReadinessEndpoint() {
    return this.readinessEndpoints.get(readinessEndpoints.size() - 1);
  }
  public String getMatchingReadinessEndpoint(Predicate<String> predicate) {
    for (String item: readinessEndpoints) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingReadinessEndpoint(Predicate<String> predicate) {
    for (String item: readinessEndpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withReadinessEndpoints(List<String> readinessEndpoints) {
    if (readinessEndpoints != null) {this.readinessEndpoints = new ArrayList(); for (String item : readinessEndpoints){this.addToReadinessEndpoints(item);}} else { this.readinessEndpoints = null;} return (A) this;
  }
  public A withReadinessEndpoints(java.lang.String... readinessEndpoints) {
    if (this.readinessEndpoints != null) {this.readinessEndpoints.clear(); _visitables.remove("readinessEndpoints"); }
    if (readinessEndpoints != null) {for (String item :readinessEndpoints){ this.addToReadinessEndpoints(item);}} return (A) this;
  }
  public Boolean hasReadinessEndpoints() {
    return readinessEndpoints != null && !readinessEndpoints.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildTrustedCA instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapNameReference getTrustedCA() {
    return this.trustedCA!=null ?this.trustedCA.build():null;
  }
  public ConfigMapNameReference buildTrustedCA() {
    return this.trustedCA!=null ?this.trustedCA.build():null;
  }
  public A withTrustedCA(ConfigMapNameReference trustedCA) {
    _visitables.get("trustedCA").remove(this.trustedCA);
    if (trustedCA!=null){ this.trustedCA= new ConfigMapNameReferenceBuilder(trustedCA); _visitables.get("trustedCA").add(this.trustedCA);} else { this.trustedCA = null; _visitables.get("trustedCA").remove(this.trustedCA); } return (A) this;
  }
  public Boolean hasTrustedCA() {
    return this.trustedCA != null;
  }
  public A withNewTrustedCA(String name) {
    return (A)withTrustedCA(new ConfigMapNameReference(name));
  }
  public ProxySpecFluentImpl.TrustedCANested<A> withNewTrustedCA() {
    return new ProxySpecFluentImpl.TrustedCANestedImpl();
  }
  public ProxySpecFluentImpl.TrustedCANested<A> withNewTrustedCALike(ConfigMapNameReference item) {
    return new ProxySpecFluentImpl.TrustedCANestedImpl(item);
  }
  public ProxySpecFluentImpl.TrustedCANested<A> editTrustedCA() {
    return withNewTrustedCALike(getTrustedCA());
  }
  public ProxySpecFluentImpl.TrustedCANested<A> editOrNewTrustedCA() {
    return withNewTrustedCALike(getTrustedCA() != null ? getTrustedCA(): new ConfigMapNameReferenceBuilder().build());
  }
  public ProxySpecFluentImpl.TrustedCANested<A> editOrNewTrustedCALike(ConfigMapNameReference item) {
    return withNewTrustedCALike(getTrustedCA() != null ? getTrustedCA(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProxySpecFluentImpl that = (ProxySpecFluentImpl) o;
    if (!java.util.Objects.equals(httpProxy, that.httpProxy)) return false;

    if (!java.util.Objects.equals(httpsProxy, that.httpsProxy)) return false;

    if (!java.util.Objects.equals(noProxy, that.noProxy)) return false;

    if (!java.util.Objects.equals(readinessEndpoints, that.readinessEndpoints)) return false;

    if (!java.util.Objects.equals(trustedCA, that.trustedCA)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(httpProxy,  httpsProxy,  noProxy,  readinessEndpoints,  trustedCA,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (httpProxy != null) { sb.append("httpProxy:"); sb.append(httpProxy + ","); }
    if (httpsProxy != null) { sb.append("httpsProxy:"); sb.append(httpsProxy + ","); }
    if (noProxy != null) { sb.append("noProxy:"); sb.append(noProxy + ","); }
    if (readinessEndpoints != null && !readinessEndpoints.isEmpty()) { sb.append("readinessEndpoints:"); sb.append(readinessEndpoints + ","); }
    if (trustedCA != null) { sb.append("trustedCA:"); sb.append(trustedCA + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class TrustedCANestedImpl<N> extends ConfigMapNameReferenceFluentImpl<ProxySpecFluentImpl.TrustedCANested<N>> implements ProxySpecFluentImpl.TrustedCANested<N>,Nested<N>{
    TrustedCANestedImpl(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    TrustedCANestedImpl() {
      this.builder = new ConfigMapNameReferenceBuilder(this);
    }
    ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) ProxySpecFluentImpl.this.withTrustedCA(builder.build());
    }
    public N endTrustedCA() {
      return and();
    }
    
  }
  
}