package io.fabric8.openshift.api.model.config.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ProxySpecFluent<A extends ProxySpecFluent<A>> extends Fluent<A>{
  public String getHttpProxy();
  public A withHttpProxy(String httpProxy);
  public Boolean hasHttpProxy();
  public String getHttpsProxy();
  public A withHttpsProxy(String httpsProxy);
  public Boolean hasHttpsProxy();
  public String getNoProxy();
  public A withNoProxy(String noProxy);
  public Boolean hasNoProxy();
  public A addToReadinessEndpoints(int index,String item);
  public A setToReadinessEndpoints(int index,String item);
  public A addToReadinessEndpoints(java.lang.String... items);
  public A addAllToReadinessEndpoints(Collection<String> items);
  public A removeFromReadinessEndpoints(java.lang.String... items);
  public A removeAllFromReadinessEndpoints(Collection<String> items);
  public List<String> getReadinessEndpoints();
  public String getReadinessEndpoint(int index);
  public String getFirstReadinessEndpoint();
  public String getLastReadinessEndpoint();
  public String getMatchingReadinessEndpoint(Predicate<String> predicate);
  public Boolean hasMatchingReadinessEndpoint(Predicate<String> predicate);
  public A withReadinessEndpoints(List<String> readinessEndpoints);
  public A withReadinessEndpoints(java.lang.String... readinessEndpoints);
  public Boolean hasReadinessEndpoints();
  
  /**
   * This method has been deprecated, please use method buildTrustedCA instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapNameReference getTrustedCA();
  public ConfigMapNameReference buildTrustedCA();
  public A withTrustedCA(ConfigMapNameReference trustedCA);
  public Boolean hasTrustedCA();
  public A withNewTrustedCA(String name);
  public ProxySpecFluent.TrustedCANested<A> withNewTrustedCA();
  public ProxySpecFluent.TrustedCANested<A> withNewTrustedCALike(ConfigMapNameReference item);
  public ProxySpecFluent.TrustedCANested<A> editTrustedCA();
  public ProxySpecFluent.TrustedCANested<A> editOrNewTrustedCA();
  public ProxySpecFluent.TrustedCANested<A> editOrNewTrustedCALike(ConfigMapNameReference item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface TrustedCANested<N> extends Nested<N>,ConfigMapNameReferenceFluent<ProxySpecFluent.TrustedCANested<N>>{
    public N and();
    public N endTrustedCA();
    
  }
  
}