package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ProxyFluent<A extends ProxyFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ProxyFluent.MetadataNested<A> withNewMetadata();
  public ProxyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ProxyFluent.MetadataNested<A> editMetadata();
  public ProxyFluent.MetadataNested<A> editOrNewMetadata();
  public ProxyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProxySpec getSpec();
  public ProxySpec buildSpec();
  public A withSpec(ProxySpec spec);
  public Boolean hasSpec();
  public ProxyFluent.SpecNested<A> withNewSpec();
  public ProxyFluent.SpecNested<A> withNewSpecLike(ProxySpec item);
  public ProxyFluent.SpecNested<A> editSpec();
  public ProxyFluent.SpecNested<A> editOrNewSpec();
  public ProxyFluent.SpecNested<A> editOrNewSpecLike(ProxySpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProxyStatus getStatus();
  public ProxyStatus buildStatus();
  public A withStatus(ProxyStatus status);
  public Boolean hasStatus();
  public A withNewStatus(String httpProxy,String httpsProxy,String noProxy);
  public ProxyFluent.StatusNested<A> withNewStatus();
  public ProxyFluent.StatusNested<A> withNewStatusLike(ProxyStatus item);
  public ProxyFluent.StatusNested<A> editStatus();
  public ProxyFluent.StatusNested<A> editOrNewStatus();
  public ProxyFluent.StatusNested<A> editOrNewStatusLike(ProxyStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ProxyFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ProxySpecFluent<ProxyFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ProxyStatusFluent<ProxyFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}