package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkStatusBuilder extends NetworkStatusFluentImpl<NetworkStatusBuilder> implements VisitableBuilder<NetworkStatus,NetworkStatusBuilder>{
  public NetworkStatusBuilder() {
    this(false);
  }
  public NetworkStatusBuilder(Boolean validationEnabled) {
    this(new NetworkStatus(), validationEnabled);
  }
  public NetworkStatusBuilder(NetworkStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkStatusBuilder(NetworkStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkStatus(), validationEnabled);
  }
  public NetworkStatusBuilder(NetworkStatusFluent<?> fluent,NetworkStatus instance) {
    this(fluent, instance, false);
  }
  public NetworkStatusBuilder(NetworkStatusFluent<?> fluent,NetworkStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClusterNetwork(instance.getClusterNetwork());
      fluent.withClusterNetworkMTU(instance.getClusterNetworkMTU());
      fluent.withMigration(instance.getMigration());
      fluent.withNetworkType(instance.getNetworkType());
      fluent.withServiceNetwork(instance.getServiceNetwork());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkStatusBuilder(NetworkStatus instance) {
    this(instance,false);
  }
  public NetworkStatusBuilder(NetworkStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClusterNetwork(instance.getClusterNetwork());
      this.withClusterNetworkMTU(instance.getClusterNetworkMTU());
      this.withMigration(instance.getMigration());
      this.withNetworkType(instance.getNetworkType());
      this.withServiceNetwork(instance.getServiceNetwork());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkStatusFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkStatus build() {
    NetworkStatus buildable = new NetworkStatus(fluent.getClusterNetwork(),fluent.getClusterNetworkMTU(),fluent.getMigration(),fluent.getNetworkType(),fluent.getServiceNetwork());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}