package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ImageListFluent<A extends ImageListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,Image item);
  public A setToItems(int index,Image item);
  public A addToItems(io.fabric8.openshift.api.model.config.v1.Image... items);
  public A addAllToItems(Collection<Image> items);
  public A removeFromItems(io.fabric8.openshift.api.model.config.v1.Image... items);
  public A removeAllFromItems(Collection<Image> items);
  public A removeMatchingFromItems(Predicate<ImageBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Image> getItems();
  public List<Image> buildItems();
  public Image buildItem(int index);
  public Image buildFirstItem();
  public Image buildLastItem();
  public Image buildMatchingItem(Predicate<ImageBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ImageBuilder> predicate);
  public A withItems(List<Image> items);
  public A withItems(io.fabric8.openshift.api.model.config.v1.Image... items);
  public Boolean hasItems();
  public ImageListFluent.ItemsNested<A> addNewItem();
  public ImageListFluent.ItemsNested<A> addNewItemLike(Image item);
  public ImageListFluent.ItemsNested<A> setNewItemLike(int index,Image item);
  public ImageListFluent.ItemsNested<A> editItem(int index);
  public ImageListFluent.ItemsNested<A> editFirstItem();
  public ImageListFluent.ItemsNested<A> editLastItem();
  public ImageListFluent.ItemsNested<A> editMatchingItem(Predicate<ImageBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ImageFluent<ImageListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}