package io.fabric8.openshift.api.model.config.v1;

import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IdentityProviderFluentImpl<A extends IdentityProviderFluent<A>> extends BaseFluent<A> implements IdentityProviderFluent<A>{
  public IdentityProviderFluentImpl() {
  }
  public IdentityProviderFluentImpl(IdentityProvider instance) {
    if (instance != null) {
      this.withBasicAuth(instance.getBasicAuth());
      this.withGithub(instance.getGithub());
      this.withGitlab(instance.getGitlab());
      this.withGoogle(instance.getGoogle());
      this.withHtpasswd(instance.getHtpasswd());
      this.withKeystone(instance.getKeystone());
      this.withLdap(instance.getLdap());
      this.withMappingMethod(instance.getMappingMethod());
      this.withName(instance.getName());
      this.withOpenID(instance.getOpenID());
      this.withRequestHeader(instance.getRequestHeader());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private BasicAuthIdentityProviderBuilder basicAuth;
  private GitHubIdentityProviderBuilder github;
  private GitLabIdentityProviderBuilder gitlab;
  private GoogleIdentityProviderBuilder google;
  private HTPasswdIdentityProviderBuilder htpasswd;
  private KeystoneIdentityProviderBuilder keystone;
  private LDAPIdentityProviderBuilder ldap;
  private String mappingMethod;
  private String name;
  private OpenIDIdentityProviderBuilder openID;
  private RequestHeaderIdentityProviderBuilder requestHeader;
  private String type;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildBasicAuth instead.
   * @return The buildable object.
   */
  @Deprecated
  public BasicAuthIdentityProvider getBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public BasicAuthIdentityProvider buildBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public A withBasicAuth(BasicAuthIdentityProvider basicAuth) {
    _visitables.get("basicAuth").remove(this.basicAuth);
    if (basicAuth!=null){ this.basicAuth= new BasicAuthIdentityProviderBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} else { this.basicAuth = null; _visitables.get("basicAuth").remove(this.basicAuth); } return (A) this;
  }
  public Boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  public IdentityProviderFluentImpl.BasicAuthNested<A> withNewBasicAuth() {
    return new IdentityProviderFluentImpl.BasicAuthNestedImpl();
  }
  public IdentityProviderFluentImpl.BasicAuthNested<A> withNewBasicAuthLike(BasicAuthIdentityProvider item) {
    return new IdentityProviderFluentImpl.BasicAuthNestedImpl(item);
  }
  public IdentityProviderFluentImpl.BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth());
  }
  public IdentityProviderFluentImpl.BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new BasicAuthIdentityProviderBuilder().build());
  }
  public IdentityProviderFluentImpl.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuthIdentityProvider item) {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGithub instead.
   * @return The buildable object.
   */
  @Deprecated
  public GitHubIdentityProvider getGithub() {
    return this.github!=null ?this.github.build():null;
  }
  public GitHubIdentityProvider buildGithub() {
    return this.github!=null ?this.github.build():null;
  }
  public A withGithub(GitHubIdentityProvider github) {
    _visitables.get("github").remove(this.github);
    if (github!=null){ this.github= new GitHubIdentityProviderBuilder(github); _visitables.get("github").add(this.github);} else { this.github = null; _visitables.get("github").remove(this.github); } return (A) this;
  }
  public Boolean hasGithub() {
    return this.github != null;
  }
  public IdentityProviderFluentImpl.GithubNested<A> withNewGithub() {
    return new IdentityProviderFluentImpl.GithubNestedImpl();
  }
  public IdentityProviderFluentImpl.GithubNested<A> withNewGithubLike(GitHubIdentityProvider item) {
    return new IdentityProviderFluentImpl.GithubNestedImpl(item);
  }
  public IdentityProviderFluentImpl.GithubNested<A> editGithub() {
    return withNewGithubLike(getGithub());
  }
  public IdentityProviderFluentImpl.GithubNested<A> editOrNewGithub() {
    return withNewGithubLike(getGithub() != null ? getGithub(): new GitHubIdentityProviderBuilder().build());
  }
  public IdentityProviderFluentImpl.GithubNested<A> editOrNewGithubLike(GitHubIdentityProvider item) {
    return withNewGithubLike(getGithub() != null ? getGithub(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGitlab instead.
   * @return The buildable object.
   */
  @Deprecated
  public GitLabIdentityProvider getGitlab() {
    return this.gitlab!=null ?this.gitlab.build():null;
  }
  public GitLabIdentityProvider buildGitlab() {
    return this.gitlab!=null ?this.gitlab.build():null;
  }
  public A withGitlab(GitLabIdentityProvider gitlab) {
    _visitables.get("gitlab").remove(this.gitlab);
    if (gitlab!=null){ this.gitlab= new GitLabIdentityProviderBuilder(gitlab); _visitables.get("gitlab").add(this.gitlab);} else { this.gitlab = null; _visitables.get("gitlab").remove(this.gitlab); } return (A) this;
  }
  public Boolean hasGitlab() {
    return this.gitlab != null;
  }
  public IdentityProviderFluentImpl.GitlabNested<A> withNewGitlab() {
    return new IdentityProviderFluentImpl.GitlabNestedImpl();
  }
  public IdentityProviderFluentImpl.GitlabNested<A> withNewGitlabLike(GitLabIdentityProvider item) {
    return new IdentityProviderFluentImpl.GitlabNestedImpl(item);
  }
  public IdentityProviderFluentImpl.GitlabNested<A> editGitlab() {
    return withNewGitlabLike(getGitlab());
  }
  public IdentityProviderFluentImpl.GitlabNested<A> editOrNewGitlab() {
    return withNewGitlabLike(getGitlab() != null ? getGitlab(): new GitLabIdentityProviderBuilder().build());
  }
  public IdentityProviderFluentImpl.GitlabNested<A> editOrNewGitlabLike(GitLabIdentityProvider item) {
    return withNewGitlabLike(getGitlab() != null ? getGitlab(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGoogle instead.
   * @return The buildable object.
   */
  @Deprecated
  public GoogleIdentityProvider getGoogle() {
    return this.google!=null ?this.google.build():null;
  }
  public GoogleIdentityProvider buildGoogle() {
    return this.google!=null ?this.google.build():null;
  }
  public A withGoogle(GoogleIdentityProvider google) {
    _visitables.get("google").remove(this.google);
    if (google!=null){ this.google= new GoogleIdentityProviderBuilder(google); _visitables.get("google").add(this.google);} else { this.google = null; _visitables.get("google").remove(this.google); } return (A) this;
  }
  public Boolean hasGoogle() {
    return this.google != null;
  }
  public IdentityProviderFluentImpl.GoogleNested<A> withNewGoogle() {
    return new IdentityProviderFluentImpl.GoogleNestedImpl();
  }
  public IdentityProviderFluentImpl.GoogleNested<A> withNewGoogleLike(GoogleIdentityProvider item) {
    return new IdentityProviderFluentImpl.GoogleNestedImpl(item);
  }
  public IdentityProviderFluentImpl.GoogleNested<A> editGoogle() {
    return withNewGoogleLike(getGoogle());
  }
  public IdentityProviderFluentImpl.GoogleNested<A> editOrNewGoogle() {
    return withNewGoogleLike(getGoogle() != null ? getGoogle(): new GoogleIdentityProviderBuilder().build());
  }
  public IdentityProviderFluentImpl.GoogleNested<A> editOrNewGoogleLike(GoogleIdentityProvider item) {
    return withNewGoogleLike(getGoogle() != null ? getGoogle(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildHtpasswd instead.
   * @return The buildable object.
   */
  @Deprecated
  public HTPasswdIdentityProvider getHtpasswd() {
    return this.htpasswd!=null ?this.htpasswd.build():null;
  }
  public HTPasswdIdentityProvider buildHtpasswd() {
    return this.htpasswd!=null ?this.htpasswd.build():null;
  }
  public A withHtpasswd(HTPasswdIdentityProvider htpasswd) {
    _visitables.get("htpasswd").remove(this.htpasswd);
    if (htpasswd!=null){ this.htpasswd= new HTPasswdIdentityProviderBuilder(htpasswd); _visitables.get("htpasswd").add(this.htpasswd);} else { this.htpasswd = null; _visitables.get("htpasswd").remove(this.htpasswd); } return (A) this;
  }
  public Boolean hasHtpasswd() {
    return this.htpasswd != null;
  }
  public IdentityProviderFluentImpl.HtpasswdNested<A> withNewHtpasswd() {
    return new IdentityProviderFluentImpl.HtpasswdNestedImpl();
  }
  public IdentityProviderFluentImpl.HtpasswdNested<A> withNewHtpasswdLike(HTPasswdIdentityProvider item) {
    return new IdentityProviderFluentImpl.HtpasswdNestedImpl(item);
  }
  public IdentityProviderFluentImpl.HtpasswdNested<A> editHtpasswd() {
    return withNewHtpasswdLike(getHtpasswd());
  }
  public IdentityProviderFluentImpl.HtpasswdNested<A> editOrNewHtpasswd() {
    return withNewHtpasswdLike(getHtpasswd() != null ? getHtpasswd(): new HTPasswdIdentityProviderBuilder().build());
  }
  public IdentityProviderFluentImpl.HtpasswdNested<A> editOrNewHtpasswdLike(HTPasswdIdentityProvider item) {
    return withNewHtpasswdLike(getHtpasswd() != null ? getHtpasswd(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKeystone instead.
   * @return The buildable object.
   */
  @Deprecated
  public KeystoneIdentityProvider getKeystone() {
    return this.keystone!=null ?this.keystone.build():null;
  }
  public KeystoneIdentityProvider buildKeystone() {
    return this.keystone!=null ?this.keystone.build():null;
  }
  public A withKeystone(KeystoneIdentityProvider keystone) {
    _visitables.get("keystone").remove(this.keystone);
    if (keystone!=null){ this.keystone= new KeystoneIdentityProviderBuilder(keystone); _visitables.get("keystone").add(this.keystone);} else { this.keystone = null; _visitables.get("keystone").remove(this.keystone); } return (A) this;
  }
  public Boolean hasKeystone() {
    return this.keystone != null;
  }
  public IdentityProviderFluentImpl.KeystoneNested<A> withNewKeystone() {
    return new IdentityProviderFluentImpl.KeystoneNestedImpl();
  }
  public IdentityProviderFluentImpl.KeystoneNested<A> withNewKeystoneLike(KeystoneIdentityProvider item) {
    return new IdentityProviderFluentImpl.KeystoneNestedImpl(item);
  }
  public IdentityProviderFluentImpl.KeystoneNested<A> editKeystone() {
    return withNewKeystoneLike(getKeystone());
  }
  public IdentityProviderFluentImpl.KeystoneNested<A> editOrNewKeystone() {
    return withNewKeystoneLike(getKeystone() != null ? getKeystone(): new KeystoneIdentityProviderBuilder().build());
  }
  public IdentityProviderFluentImpl.KeystoneNested<A> editOrNewKeystoneLike(KeystoneIdentityProvider item) {
    return withNewKeystoneLike(getKeystone() != null ? getKeystone(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLdap instead.
   * @return The buildable object.
   */
  @Deprecated
  public LDAPIdentityProvider getLdap() {
    return this.ldap!=null ?this.ldap.build():null;
  }
  public LDAPIdentityProvider buildLdap() {
    return this.ldap!=null ?this.ldap.build():null;
  }
  public A withLdap(LDAPIdentityProvider ldap) {
    _visitables.get("ldap").remove(this.ldap);
    if (ldap!=null){ this.ldap= new LDAPIdentityProviderBuilder(ldap); _visitables.get("ldap").add(this.ldap);} else { this.ldap = null; _visitables.get("ldap").remove(this.ldap); } return (A) this;
  }
  public Boolean hasLdap() {
    return this.ldap != null;
  }
  public IdentityProviderFluentImpl.LdapNested<A> withNewLdap() {
    return new IdentityProviderFluentImpl.LdapNestedImpl();
  }
  public IdentityProviderFluentImpl.LdapNested<A> withNewLdapLike(LDAPIdentityProvider item) {
    return new IdentityProviderFluentImpl.LdapNestedImpl(item);
  }
  public IdentityProviderFluentImpl.LdapNested<A> editLdap() {
    return withNewLdapLike(getLdap());
  }
  public IdentityProviderFluentImpl.LdapNested<A> editOrNewLdap() {
    return withNewLdapLike(getLdap() != null ? getLdap(): new LDAPIdentityProviderBuilder().build());
  }
  public IdentityProviderFluentImpl.LdapNested<A> editOrNewLdapLike(LDAPIdentityProvider item) {
    return withNewLdapLike(getLdap() != null ? getLdap(): item);
  }
  public String getMappingMethod() {
    return this.mappingMethod;
  }
  public A withMappingMethod(String mappingMethod) {
    this.mappingMethod=mappingMethod; return (A) this;
  }
  public Boolean hasMappingMethod() {
    return this.mappingMethod != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOpenID instead.
   * @return The buildable object.
   */
  @Deprecated
  public OpenIDIdentityProvider getOpenID() {
    return this.openID!=null ?this.openID.build():null;
  }
  public OpenIDIdentityProvider buildOpenID() {
    return this.openID!=null ?this.openID.build():null;
  }
  public A withOpenID(OpenIDIdentityProvider openID) {
    _visitables.get("openID").remove(this.openID);
    if (openID!=null){ this.openID= new OpenIDIdentityProviderBuilder(openID); _visitables.get("openID").add(this.openID);} else { this.openID = null; _visitables.get("openID").remove(this.openID); } return (A) this;
  }
  public Boolean hasOpenID() {
    return this.openID != null;
  }
  public IdentityProviderFluentImpl.OpenIDNested<A> withNewOpenID() {
    return new IdentityProviderFluentImpl.OpenIDNestedImpl();
  }
  public IdentityProviderFluentImpl.OpenIDNested<A> withNewOpenIDLike(OpenIDIdentityProvider item) {
    return new IdentityProviderFluentImpl.OpenIDNestedImpl(item);
  }
  public IdentityProviderFluentImpl.OpenIDNested<A> editOpenID() {
    return withNewOpenIDLike(getOpenID());
  }
  public IdentityProviderFluentImpl.OpenIDNested<A> editOrNewOpenID() {
    return withNewOpenIDLike(getOpenID() != null ? getOpenID(): new OpenIDIdentityProviderBuilder().build());
  }
  public IdentityProviderFluentImpl.OpenIDNested<A> editOrNewOpenIDLike(OpenIDIdentityProvider item) {
    return withNewOpenIDLike(getOpenID() != null ? getOpenID(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRequestHeader instead.
   * @return The buildable object.
   */
  @Deprecated
  public RequestHeaderIdentityProvider getRequestHeader() {
    return this.requestHeader!=null ?this.requestHeader.build():null;
  }
  public RequestHeaderIdentityProvider buildRequestHeader() {
    return this.requestHeader!=null ?this.requestHeader.build():null;
  }
  public A withRequestHeader(RequestHeaderIdentityProvider requestHeader) {
    _visitables.get("requestHeader").remove(this.requestHeader);
    if (requestHeader!=null){ this.requestHeader= new RequestHeaderIdentityProviderBuilder(requestHeader); _visitables.get("requestHeader").add(this.requestHeader);} else { this.requestHeader = null; _visitables.get("requestHeader").remove(this.requestHeader); } return (A) this;
  }
  public Boolean hasRequestHeader() {
    return this.requestHeader != null;
  }
  public IdentityProviderFluentImpl.RequestHeaderNested<A> withNewRequestHeader() {
    return new IdentityProviderFluentImpl.RequestHeaderNestedImpl();
  }
  public IdentityProviderFluentImpl.RequestHeaderNested<A> withNewRequestHeaderLike(RequestHeaderIdentityProvider item) {
    return new IdentityProviderFluentImpl.RequestHeaderNestedImpl(item);
  }
  public IdentityProviderFluentImpl.RequestHeaderNested<A> editRequestHeader() {
    return withNewRequestHeaderLike(getRequestHeader());
  }
  public IdentityProviderFluentImpl.RequestHeaderNested<A> editOrNewRequestHeader() {
    return withNewRequestHeaderLike(getRequestHeader() != null ? getRequestHeader(): new RequestHeaderIdentityProviderBuilder().build());
  }
  public IdentityProviderFluentImpl.RequestHeaderNested<A> editOrNewRequestHeaderLike(RequestHeaderIdentityProvider item) {
    return withNewRequestHeaderLike(getRequestHeader() != null ? getRequestHeader(): item);
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IdentityProviderFluentImpl that = (IdentityProviderFluentImpl) o;
    if (!java.util.Objects.equals(basicAuth, that.basicAuth)) return false;

    if (!java.util.Objects.equals(github, that.github)) return false;

    if (!java.util.Objects.equals(gitlab, that.gitlab)) return false;

    if (!java.util.Objects.equals(google, that.google)) return false;

    if (!java.util.Objects.equals(htpasswd, that.htpasswd)) return false;

    if (!java.util.Objects.equals(keystone, that.keystone)) return false;

    if (!java.util.Objects.equals(ldap, that.ldap)) return false;

    if (!java.util.Objects.equals(mappingMethod, that.mappingMethod)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(openID, that.openID)) return false;

    if (!java.util.Objects.equals(requestHeader, that.requestHeader)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(basicAuth,  github,  gitlab,  google,  htpasswd,  keystone,  ldap,  mappingMethod,  name,  openID,  requestHeader,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (github != null) { sb.append("github:"); sb.append(github + ","); }
    if (gitlab != null) { sb.append("gitlab:"); sb.append(gitlab + ","); }
    if (google != null) { sb.append("google:"); sb.append(google + ","); }
    if (htpasswd != null) { sb.append("htpasswd:"); sb.append(htpasswd + ","); }
    if (keystone != null) { sb.append("keystone:"); sb.append(keystone + ","); }
    if (ldap != null) { sb.append("ldap:"); sb.append(ldap + ","); }
    if (mappingMethod != null) { sb.append("mappingMethod:"); sb.append(mappingMethod + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (openID != null) { sb.append("openID:"); sb.append(openID + ","); }
    if (requestHeader != null) { sb.append("requestHeader:"); sb.append(requestHeader + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class BasicAuthNestedImpl<N> extends BasicAuthIdentityProviderFluentImpl<IdentityProviderFluentImpl.BasicAuthNested<N>> implements IdentityProviderFluentImpl.BasicAuthNested<N>,Nested<N>{
    BasicAuthNestedImpl(BasicAuthIdentityProvider item) {
      this.builder = new BasicAuthIdentityProviderBuilder(this, item);
    }
    BasicAuthNestedImpl() {
      this.builder = new BasicAuthIdentityProviderBuilder(this);
    }
    BasicAuthIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth() {
      return and();
    }
    
  }
  class GithubNestedImpl<N> extends GitHubIdentityProviderFluentImpl<IdentityProviderFluentImpl.GithubNested<N>> implements IdentityProviderFluentImpl.GithubNested<N>,Nested<N>{
    GithubNestedImpl(GitHubIdentityProvider item) {
      this.builder = new GitHubIdentityProviderBuilder(this, item);
    }
    GithubNestedImpl() {
      this.builder = new GitHubIdentityProviderBuilder(this);
    }
    GitHubIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withGithub(builder.build());
    }
    public N endGithub() {
      return and();
    }
    
  }
  class GitlabNestedImpl<N> extends GitLabIdentityProviderFluentImpl<IdentityProviderFluentImpl.GitlabNested<N>> implements IdentityProviderFluentImpl.GitlabNested<N>,Nested<N>{
    GitlabNestedImpl(GitLabIdentityProvider item) {
      this.builder = new GitLabIdentityProviderBuilder(this, item);
    }
    GitlabNestedImpl() {
      this.builder = new GitLabIdentityProviderBuilder(this);
    }
    GitLabIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withGitlab(builder.build());
    }
    public N endGitlab() {
      return and();
    }
    
  }
  class GoogleNestedImpl<N> extends GoogleIdentityProviderFluentImpl<IdentityProviderFluentImpl.GoogleNested<N>> implements IdentityProviderFluentImpl.GoogleNested<N>,Nested<N>{
    GoogleNestedImpl(GoogleIdentityProvider item) {
      this.builder = new GoogleIdentityProviderBuilder(this, item);
    }
    GoogleNestedImpl() {
      this.builder = new GoogleIdentityProviderBuilder(this);
    }
    GoogleIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withGoogle(builder.build());
    }
    public N endGoogle() {
      return and();
    }
    
  }
  class HtpasswdNestedImpl<N> extends HTPasswdIdentityProviderFluentImpl<IdentityProviderFluentImpl.HtpasswdNested<N>> implements IdentityProviderFluentImpl.HtpasswdNested<N>,Nested<N>{
    HtpasswdNestedImpl(HTPasswdIdentityProvider item) {
      this.builder = new HTPasswdIdentityProviderBuilder(this, item);
    }
    HtpasswdNestedImpl() {
      this.builder = new HTPasswdIdentityProviderBuilder(this);
    }
    HTPasswdIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withHtpasswd(builder.build());
    }
    public N endHtpasswd() {
      return and();
    }
    
  }
  class KeystoneNestedImpl<N> extends KeystoneIdentityProviderFluentImpl<IdentityProviderFluentImpl.KeystoneNested<N>> implements IdentityProviderFluentImpl.KeystoneNested<N>,Nested<N>{
    KeystoneNestedImpl(KeystoneIdentityProvider item) {
      this.builder = new KeystoneIdentityProviderBuilder(this, item);
    }
    KeystoneNestedImpl() {
      this.builder = new KeystoneIdentityProviderBuilder(this);
    }
    KeystoneIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withKeystone(builder.build());
    }
    public N endKeystone() {
      return and();
    }
    
  }
  class LdapNestedImpl<N> extends LDAPIdentityProviderFluentImpl<IdentityProviderFluentImpl.LdapNested<N>> implements IdentityProviderFluentImpl.LdapNested<N>,Nested<N>{
    LdapNestedImpl(LDAPIdentityProvider item) {
      this.builder = new LDAPIdentityProviderBuilder(this, item);
    }
    LdapNestedImpl() {
      this.builder = new LDAPIdentityProviderBuilder(this);
    }
    LDAPIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withLdap(builder.build());
    }
    public N endLdap() {
      return and();
    }
    
  }
  class OpenIDNestedImpl<N> extends OpenIDIdentityProviderFluentImpl<IdentityProviderFluentImpl.OpenIDNested<N>> implements IdentityProviderFluentImpl.OpenIDNested<N>,Nested<N>{
    OpenIDNestedImpl(OpenIDIdentityProvider item) {
      this.builder = new OpenIDIdentityProviderBuilder(this, item);
    }
    OpenIDNestedImpl() {
      this.builder = new OpenIDIdentityProviderBuilder(this);
    }
    OpenIDIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withOpenID(builder.build());
    }
    public N endOpenID() {
      return and();
    }
    
  }
  class RequestHeaderNestedImpl<N> extends RequestHeaderIdentityProviderFluentImpl<IdentityProviderFluentImpl.RequestHeaderNested<N>> implements IdentityProviderFluentImpl.RequestHeaderNested<N>,Nested<N>{
    RequestHeaderNestedImpl(RequestHeaderIdentityProvider item) {
      this.builder = new RequestHeaderIdentityProviderBuilder(this, item);
    }
    RequestHeaderNestedImpl() {
      this.builder = new RequestHeaderIdentityProviderBuilder(this);
    }
    RequestHeaderIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withRequestHeader(builder.build());
    }
    public N endRequestHeader() {
      return and();
    }
    
  }
  
}