package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IBMCloudPlatformSpecBuilder extends IBMCloudPlatformSpecFluentImpl<IBMCloudPlatformSpecBuilder> implements VisitableBuilder<IBMCloudPlatformSpec,IBMCloudPlatformSpecBuilder>{
  public IBMCloudPlatformSpecBuilder() {
    this(false);
  }
  public IBMCloudPlatformSpecBuilder(Boolean validationEnabled) {
    this(new IBMCloudPlatformSpec(), validationEnabled);
  }
  public IBMCloudPlatformSpecBuilder(IBMCloudPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IBMCloudPlatformSpecBuilder(IBMCloudPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IBMCloudPlatformSpec(), validationEnabled);
  }
  public IBMCloudPlatformSpecBuilder(IBMCloudPlatformSpecFluent<?> fluent,IBMCloudPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public IBMCloudPlatformSpecBuilder(IBMCloudPlatformSpecFluent<?> fluent,IBMCloudPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IBMCloudPlatformSpecBuilder(IBMCloudPlatformSpec instance) {
    this(instance,false);
  }
  public IBMCloudPlatformSpecBuilder(IBMCloudPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IBMCloudPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IBMCloudPlatformSpec build() {
    IBMCloudPlatformSpec buildable = new IBMCloudPlatformSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}