package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GoogleIdentityProviderBuilder extends GoogleIdentityProviderFluentImpl<GoogleIdentityProviderBuilder> implements VisitableBuilder<GoogleIdentityProvider,GoogleIdentityProviderBuilder>{
  public GoogleIdentityProviderBuilder() {
    this(false);
  }
  public GoogleIdentityProviderBuilder(Boolean validationEnabled) {
    this(new GoogleIdentityProvider(), validationEnabled);
  }
  public GoogleIdentityProviderBuilder(GoogleIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public GoogleIdentityProviderBuilder(GoogleIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GoogleIdentityProvider(), validationEnabled);
  }
  public GoogleIdentityProviderBuilder(GoogleIdentityProviderFluent<?> fluent,GoogleIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public GoogleIdentityProviderBuilder(GoogleIdentityProviderFluent<?> fluent,GoogleIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClientID(instance.getClientID());
      fluent.withClientSecret(instance.getClientSecret());
      fluent.withHostedDomain(instance.getHostedDomain());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GoogleIdentityProviderBuilder(GoogleIdentityProvider instance) {
    this(instance,false);
  }
  public GoogleIdentityProviderBuilder(GoogleIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClientID(instance.getClientID());
      this.withClientSecret(instance.getClientSecret());
      this.withHostedDomain(instance.getHostedDomain());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GoogleIdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public GoogleIdentityProvider build() {
    GoogleIdentityProvider buildable = new GoogleIdentityProvider(fluent.getClientID(),fluent.getClientSecret(),fluent.getHostedDomain());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}