package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EquinixMetalPlatformStatusBuilder extends EquinixMetalPlatformStatusFluentImpl<EquinixMetalPlatformStatusBuilder> implements VisitableBuilder<EquinixMetalPlatformStatus,EquinixMetalPlatformStatusBuilder>{
  public EquinixMetalPlatformStatusBuilder() {
    this(false);
  }
  public EquinixMetalPlatformStatusBuilder(Boolean validationEnabled) {
    this(new EquinixMetalPlatformStatus(), validationEnabled);
  }
  public EquinixMetalPlatformStatusBuilder(EquinixMetalPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public EquinixMetalPlatformStatusBuilder(EquinixMetalPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EquinixMetalPlatformStatus(), validationEnabled);
  }
  public EquinixMetalPlatformStatusBuilder(EquinixMetalPlatformStatusFluent<?> fluent,EquinixMetalPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public EquinixMetalPlatformStatusBuilder(EquinixMetalPlatformStatusFluent<?> fluent,EquinixMetalPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiServerInternalIP(instance.getApiServerInternalIP());
      fluent.withIngressIP(instance.getIngressIP());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EquinixMetalPlatformStatusBuilder(EquinixMetalPlatformStatus instance) {
    this(instance,false);
  }
  public EquinixMetalPlatformStatusBuilder(EquinixMetalPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiServerInternalIP(instance.getApiServerInternalIP());
      this.withIngressIP(instance.getIngressIP());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EquinixMetalPlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public EquinixMetalPlatformStatus build() {
    EquinixMetalPlatformStatus buildable = new EquinixMetalPlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}