package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EquinixMetalPlatformSpecBuilder extends EquinixMetalPlatformSpecFluentImpl<EquinixMetalPlatformSpecBuilder> implements VisitableBuilder<EquinixMetalPlatformSpec,EquinixMetalPlatformSpecBuilder>{
  public EquinixMetalPlatformSpecBuilder() {
    this(false);
  }
  public EquinixMetalPlatformSpecBuilder(Boolean validationEnabled) {
    this(new EquinixMetalPlatformSpec(), validationEnabled);
  }
  public EquinixMetalPlatformSpecBuilder(EquinixMetalPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public EquinixMetalPlatformSpecBuilder(EquinixMetalPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EquinixMetalPlatformSpec(), validationEnabled);
  }
  public EquinixMetalPlatformSpecBuilder(EquinixMetalPlatformSpecFluent<?> fluent,EquinixMetalPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public EquinixMetalPlatformSpecBuilder(EquinixMetalPlatformSpecFluent<?> fluent,EquinixMetalPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EquinixMetalPlatformSpecBuilder(EquinixMetalPlatformSpec instance) {
    this(instance,false);
  }
  public EquinixMetalPlatformSpecBuilder(EquinixMetalPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EquinixMetalPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public EquinixMetalPlatformSpec build() {
    EquinixMetalPlatformSpec buildable = new EquinixMetalPlatformSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}