package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleSpecBuilder extends ConsoleSpecFluentImpl<ConsoleSpecBuilder> implements VisitableBuilder<ConsoleSpec,ConsoleSpecBuilder>{
  public ConsoleSpecBuilder() {
    this(false);
  }
  public ConsoleSpecBuilder(Boolean validationEnabled) {
    this(new ConsoleSpec(), validationEnabled);
  }
  public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleSpec(), validationEnabled);
  }
  public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent,ConsoleSpec instance) {
    this(fluent, instance, false);
  }
  public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent,ConsoleSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAuthentication(instance.getAuthentication());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleSpecBuilder(ConsoleSpec instance) {
    this(instance,false);
  }
  public ConsoleSpecBuilder(ConsoleSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAuthentication(instance.getAuthentication());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleSpec build() {
    ConsoleSpec buildable = new ConsoleSpec(fluent.getAuthentication());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}