package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleBuilder extends ConsoleFluentImpl<ConsoleBuilder> implements VisitableBuilder<Console,ConsoleBuilder>{
  public ConsoleBuilder() {
    this(false);
  }
  public ConsoleBuilder(Boolean validationEnabled) {
    this(new Console(), validationEnabled);
  }
  public ConsoleBuilder(ConsoleFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleBuilder(ConsoleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Console(), validationEnabled);
  }
  public ConsoleBuilder(ConsoleFluent<?> fluent,Console instance) {
    this(fluent, instance, false);
  }
  public ConsoleBuilder(ConsoleFluent<?> fluent,Console instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleBuilder(Console instance) {
    this(instance,false);
  }
  public ConsoleBuilder(Console instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleFluent<?> fluent;
  Boolean validationEnabled;
  public Console build() {
    Console buildable = new Console(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}