package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapFileReferenceBuilder extends ConfigMapFileReferenceFluentImpl<ConfigMapFileReferenceBuilder> implements VisitableBuilder<ConfigMapFileReference,ConfigMapFileReferenceBuilder>{
  public ConfigMapFileReferenceBuilder() {
    this(false);
  }
  public ConfigMapFileReferenceBuilder(Boolean validationEnabled) {
    this(new ConfigMapFileReference(), validationEnabled);
  }
  public ConfigMapFileReferenceBuilder(ConfigMapFileReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapFileReferenceBuilder(ConfigMapFileReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMapFileReference(), validationEnabled);
  }
  public ConfigMapFileReferenceBuilder(ConfigMapFileReferenceFluent<?> fluent,ConfigMapFileReference instance) {
    this(fluent, instance, false);
  }
  public ConfigMapFileReferenceBuilder(ConfigMapFileReferenceFluent<?> fluent,ConfigMapFileReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withKey(instance.getKey());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapFileReferenceBuilder(ConfigMapFileReference instance) {
    this(instance,false);
  }
  public ConfigMapFileReferenceBuilder(ConfigMapFileReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withKey(instance.getKey());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigMapFileReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMapFileReference build() {
    ConfigMapFileReference buildable = new ConfigMapFileReference(fluent.getKey(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}