package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConditionalUpdateBuilder extends ConditionalUpdateFluentImpl<ConditionalUpdateBuilder> implements VisitableBuilder<ConditionalUpdate,ConditionalUpdateBuilder>{
  public ConditionalUpdateBuilder() {
    this(false);
  }
  public ConditionalUpdateBuilder(Boolean validationEnabled) {
    this(new ConditionalUpdate(), validationEnabled);
  }
  public ConditionalUpdateBuilder(ConditionalUpdateFluent<?> fluent) {
    this(fluent, false);
  }
  public ConditionalUpdateBuilder(ConditionalUpdateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConditionalUpdate(), validationEnabled);
  }
  public ConditionalUpdateBuilder(ConditionalUpdateFluent<?> fluent,ConditionalUpdate instance) {
    this(fluent, instance, false);
  }
  public ConditionalUpdateBuilder(ConditionalUpdateFluent<?> fluent,ConditionalUpdate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withRelease(instance.getRelease());
      fluent.withRisks(instance.getRisks());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConditionalUpdateBuilder(ConditionalUpdate instance) {
    this(instance,false);
  }
  public ConditionalUpdateBuilder(ConditionalUpdate instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withRelease(instance.getRelease());
      this.withRisks(instance.getRisks());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConditionalUpdateFluent<?> fluent;
  Boolean validationEnabled;
  public ConditionalUpdate build() {
    ConditionalUpdate buildable = new ConditionalUpdate(fluent.getConditions(),fluent.getRelease(),fluent.getRisks());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}