package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ComponentRouteStatusBuilder extends ComponentRouteStatusFluentImpl<ComponentRouteStatusBuilder> implements VisitableBuilder<ComponentRouteStatus,ComponentRouteStatusBuilder>{
  public ComponentRouteStatusBuilder() {
    this(false);
  }
  public ComponentRouteStatusBuilder(Boolean validationEnabled) {
    this(new ComponentRouteStatus(), validationEnabled);
  }
  public ComponentRouteStatusBuilder(ComponentRouteStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ComponentRouteStatusBuilder(ComponentRouteStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ComponentRouteStatus(), validationEnabled);
  }
  public ComponentRouteStatusBuilder(ComponentRouteStatusFluent<?> fluent,ComponentRouteStatus instance) {
    this(fluent, instance, false);
  }
  public ComponentRouteStatusBuilder(ComponentRouteStatusFluent<?> fluent,ComponentRouteStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withConsumingUsers(instance.getConsumingUsers());
      fluent.withCurrentHostnames(instance.getCurrentHostnames());
      fluent.withDefaultHostname(instance.getDefaultHostname());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withRelatedObjects(instance.getRelatedObjects());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ComponentRouteStatusBuilder(ComponentRouteStatus instance) {
    this(instance,false);
  }
  public ComponentRouteStatusBuilder(ComponentRouteStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withConsumingUsers(instance.getConsumingUsers());
      this.withCurrentHostnames(instance.getCurrentHostnames());
      this.withDefaultHostname(instance.getDefaultHostname());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withRelatedObjects(instance.getRelatedObjects());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ComponentRouteStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ComponentRouteStatus build() {
    ComponentRouteStatus buildable = new ComponentRouteStatus(fluent.getConditions(),fluent.getConsumingUsers(),fluent.getCurrentHostnames(),fluent.getDefaultHostname(),fluent.getName(),fluent.getNamespace(),fluent.getRelatedObjects());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}