package io.fabric8.openshift.api.model.config.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ComponentRouteSpecFluent<A extends ComponentRouteSpecFluent<A>> extends Fluent<A>{
  public String getHostname();
  public A withHostname(String hostname);
  public Boolean hasHostname();
  public String getName();
  public A withName(String name);
  public Boolean hasName();
  public String getNamespace();
  public A withNamespace(String namespace);
  public Boolean hasNamespace();
  
  /**
   * This method has been deprecated, please use method buildServingCertKeyPairSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretNameReference getServingCertKeyPairSecret();
  public SecretNameReference buildServingCertKeyPairSecret();
  public A withServingCertKeyPairSecret(SecretNameReference servingCertKeyPairSecret);
  public Boolean hasServingCertKeyPairSecret();
  public A withNewServingCertKeyPairSecret(String name);
  public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> withNewServingCertKeyPairSecret();
  public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> withNewServingCertKeyPairSecretLike(SecretNameReference item);
  public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> editServingCertKeyPairSecret();
  public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> editOrNewServingCertKeyPairSecret();
  public ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<A> editOrNewServingCertKeyPairSecretLike(SecretNameReference item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ServingCertKeyPairSecretNested<N> extends Nested<N>,SecretNameReferenceFluent<ComponentRouteSpecFluent.ServingCertKeyPairSecretNested<N>>{
    public N and();
    public N endServingCertKeyPairSecret();
    
  }
  
}