package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterOperatorSpecBuilder extends ClusterOperatorSpecFluentImpl<ClusterOperatorSpecBuilder> implements VisitableBuilder<ClusterOperatorSpec,ClusterOperatorSpecBuilder>{
  public ClusterOperatorSpecBuilder() {
    this(false);
  }
  public ClusterOperatorSpecBuilder(Boolean validationEnabled) {
    this(new ClusterOperatorSpec(), validationEnabled);
  }
  public ClusterOperatorSpecBuilder(ClusterOperatorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterOperatorSpecBuilder(ClusterOperatorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterOperatorSpec(), validationEnabled);
  }
  public ClusterOperatorSpecBuilder(ClusterOperatorSpecFluent<?> fluent,ClusterOperatorSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterOperatorSpecBuilder(ClusterOperatorSpecFluent<?> fluent,ClusterOperatorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterOperatorSpecBuilder(ClusterOperatorSpec instance) {
    this(instance,false);
  }
  public ClusterOperatorSpecBuilder(ClusterOperatorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterOperatorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterOperatorSpec build() {
    ClusterOperatorSpec buildable = new ClusterOperatorSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}