package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildDefaultsFluentImpl<A extends BuildDefaultsFluent<A>> extends BaseFluent<A> implements BuildDefaultsFluent<A>{
  public BuildDefaultsFluentImpl() {
  }
  public BuildDefaultsFluentImpl(BuildDefaults instance) {
    if (instance != null) {
      this.withDefaultProxy(instance.getDefaultProxy());
      this.withEnv(instance.getEnv());
      this.withGitProxy(instance.getGitProxy());
      this.withImageLabels(instance.getImageLabels());
      this.withResources(instance.getResources());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ProxySpecBuilder defaultProxy;
  private List<EnvVar> env = new ArrayList<EnvVar>();
  private ProxySpecBuilder gitProxy;
  private ArrayList<ImageLabelBuilder> imageLabels = new ArrayList<ImageLabelBuilder>();
  private ResourceRequirementsBuilder resources;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildDefaultProxy instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProxySpec getDefaultProxy() {
    return this.defaultProxy!=null ?this.defaultProxy.build():null;
  }
  public ProxySpec buildDefaultProxy() {
    return this.defaultProxy!=null ?this.defaultProxy.build():null;
  }
  public A withDefaultProxy(ProxySpec defaultProxy) {
    _visitables.get("defaultProxy").remove(this.defaultProxy);
    if (defaultProxy!=null){ this.defaultProxy= new ProxySpecBuilder(defaultProxy); _visitables.get("defaultProxy").add(this.defaultProxy);} else { this.defaultProxy = null; _visitables.get("defaultProxy").remove(this.defaultProxy); } return (A) this;
  }
  public Boolean hasDefaultProxy() {
    return this.defaultProxy != null;
  }
  public BuildDefaultsFluentImpl.DefaultProxyNested<A> withNewDefaultProxy() {
    return new BuildDefaultsFluentImpl.DefaultProxyNestedImpl();
  }
  public BuildDefaultsFluentImpl.DefaultProxyNested<A> withNewDefaultProxyLike(ProxySpec item) {
    return new BuildDefaultsFluentImpl.DefaultProxyNestedImpl(item);
  }
  public BuildDefaultsFluentImpl.DefaultProxyNested<A> editDefaultProxy() {
    return withNewDefaultProxyLike(getDefaultProxy());
  }
  public BuildDefaultsFluentImpl.DefaultProxyNested<A> editOrNewDefaultProxy() {
    return withNewDefaultProxyLike(getDefaultProxy() != null ? getDefaultProxy(): new ProxySpecBuilder().build());
  }
  public BuildDefaultsFluentImpl.DefaultProxyNested<A> editOrNewDefaultProxyLike(ProxySpec item) {
    return withNewDefaultProxyLike(getDefaultProxy() != null ? getDefaultProxy(): item);
  }
  public A addToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.add(index, item);
    return (A)this;
  }
  public A setToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.set(index, item); return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public A removeAllFromEnv(Collection<EnvVar> items) {
    for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public List<EnvVar> getEnv() {
    return this.env;
  }
  public EnvVar getEnv(int index) {
    return this.env.get(index);
  }
  public EnvVar getFirstEnv() {
    return this.env.get(0);
  }
  public EnvVar getLastEnv() {
    return this.env.get(env.size() - 1);
  }
  public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(List<EnvVar> env) {
    if (env != null) {this.env = new ArrayList(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear(); _visitables.remove("env"); }
    if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildGitProxy instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProxySpec getGitProxy() {
    return this.gitProxy!=null ?this.gitProxy.build():null;
  }
  public ProxySpec buildGitProxy() {
    return this.gitProxy!=null ?this.gitProxy.build():null;
  }
  public A withGitProxy(ProxySpec gitProxy) {
    _visitables.get("gitProxy").remove(this.gitProxy);
    if (gitProxy!=null){ this.gitProxy= new ProxySpecBuilder(gitProxy); _visitables.get("gitProxy").add(this.gitProxy);} else { this.gitProxy = null; _visitables.get("gitProxy").remove(this.gitProxy); } return (A) this;
  }
  public Boolean hasGitProxy() {
    return this.gitProxy != null;
  }
  public BuildDefaultsFluentImpl.GitProxyNested<A> withNewGitProxy() {
    return new BuildDefaultsFluentImpl.GitProxyNestedImpl();
  }
  public BuildDefaultsFluentImpl.GitProxyNested<A> withNewGitProxyLike(ProxySpec item) {
    return new BuildDefaultsFluentImpl.GitProxyNestedImpl(item);
  }
  public BuildDefaultsFluentImpl.GitProxyNested<A> editGitProxy() {
    return withNewGitProxyLike(getGitProxy());
  }
  public BuildDefaultsFluentImpl.GitProxyNested<A> editOrNewGitProxy() {
    return withNewGitProxyLike(getGitProxy() != null ? getGitProxy(): new ProxySpecBuilder().build());
  }
  public BuildDefaultsFluentImpl.GitProxyNested<A> editOrNewGitProxyLike(ProxySpec item) {
    return withNewGitProxyLike(getGitProxy() != null ? getGitProxy(): item);
  }
  public A addToImageLabels(int index,ImageLabel item) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    ImageLabelBuilder builder = new ImageLabelBuilder(item);
    if (index < 0 || index >= imageLabels.size()) { _visitables.get("imageLabels").add(builder); imageLabels.add(builder); } else { _visitables.get("imageLabels").add(index, builder); imageLabels.add(index, builder);}
    return (A)this;
  }
  public A setToImageLabels(int index,ImageLabel item) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    ImageLabelBuilder builder = new ImageLabelBuilder(item);
    if (index < 0 || index >= imageLabels.size()) { _visitables.get("imageLabels").add(builder); imageLabels.add(builder); } else { _visitables.get("imageLabels").set(index, builder); imageLabels.set(index, builder);}
    return (A)this;
  }
  public A addToImageLabels(io.fabric8.openshift.api.model.config.v1.ImageLabel... items) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").add(builder);this.imageLabels.add(builder);} return (A)this;
  }
  public A addAllToImageLabels(Collection<ImageLabel> items) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").add(builder);this.imageLabels.add(builder);} return (A)this;
  }
  public A removeFromImageLabels(io.fabric8.openshift.api.model.config.v1.ImageLabel... items) {
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").remove(builder);if (this.imageLabels != null) {this.imageLabels.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageLabels(Collection<ImageLabel> items) {
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").remove(builder);if (this.imageLabels != null) {this.imageLabels.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageLabels(Predicate<ImageLabelBuilder> predicate) {
    if (imageLabels == null) return (A) this;
    final Iterator<ImageLabelBuilder> each = imageLabels.iterator();
    final List visitables = _visitables.get("imageLabels");
    while (each.hasNext()) {
      ImageLabelBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImageLabels instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageLabel> getImageLabels() {
    return imageLabels != null ? build(imageLabels) : null;
  }
  public List<ImageLabel> buildImageLabels() {
    return imageLabels != null ? build(imageLabels) : null;
  }
  public ImageLabel buildImageLabel(int index) {
    return this.imageLabels.get(index).build();
  }
  public ImageLabel buildFirstImageLabel() {
    return this.imageLabels.get(0).build();
  }
  public ImageLabel buildLastImageLabel() {
    return this.imageLabels.get(imageLabels.size() - 1).build();
  }
  public ImageLabel buildMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
    for (ImageLabelBuilder item: imageLabels) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
    for (ImageLabelBuilder item: imageLabels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImageLabels(List<ImageLabel> imageLabels) {
    if (this.imageLabels != null) { _visitables.get("imageLabels").clear();}
    if (imageLabels != null) {this.imageLabels = new ArrayList(); for (ImageLabel item : imageLabels){this.addToImageLabels(item);}} else { this.imageLabels = null;} return (A) this;
  }
  public A withImageLabels(io.fabric8.openshift.api.model.config.v1.ImageLabel... imageLabels) {
    if (this.imageLabels != null) {this.imageLabels.clear(); _visitables.remove("imageLabels"); }
    if (imageLabels != null) {for (ImageLabel item :imageLabels){ this.addToImageLabels(item);}} return (A) this;
  }
  public Boolean hasImageLabels() {
    return imageLabels != null && !imageLabels.isEmpty();
  }
  public A addNewImageLabel(String name,String value) {
    return (A)addToImageLabels(new ImageLabel(name, value));
  }
  public BuildDefaultsFluentImpl.ImageLabelsNested<A> addNewImageLabel() {
    return new BuildDefaultsFluentImpl.ImageLabelsNestedImpl();
  }
  public BuildDefaultsFluentImpl.ImageLabelsNested<A> addNewImageLabelLike(ImageLabel item) {
    return new BuildDefaultsFluentImpl.ImageLabelsNestedImpl(-1, item);
  }
  public BuildDefaultsFluentImpl.ImageLabelsNested<A> setNewImageLabelLike(int index,ImageLabel item) {
    return new BuildDefaultsFluentImpl.ImageLabelsNestedImpl(index, item);
  }
  public BuildDefaultsFluentImpl.ImageLabelsNested<A> editImageLabel(int index) {
    if (imageLabels.size() <= index) throw new RuntimeException("Can't edit imageLabels. Index exceeds size.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  public BuildDefaultsFluentImpl.ImageLabelsNested<A> editFirstImageLabel() {
    if (imageLabels.size() == 0) throw new RuntimeException("Can't edit first imageLabels. The list is empty.");
    return setNewImageLabelLike(0, buildImageLabel(0));
  }
  public BuildDefaultsFluentImpl.ImageLabelsNested<A> editLastImageLabel() {
    int index = imageLabels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imageLabels. The list is empty.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  public BuildDefaultsFluentImpl.ImageLabelsNested<A> editMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imageLabels.size();i++) { 
    if (predicate.test(imageLabels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imageLabels. No match found.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public BuildDefaultsFluentImpl.ResourcesNested<A> withNewResources() {
    return new BuildDefaultsFluentImpl.ResourcesNestedImpl();
  }
  public BuildDefaultsFluentImpl.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new BuildDefaultsFluentImpl.ResourcesNestedImpl(item);
  }
  public BuildDefaultsFluentImpl.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public BuildDefaultsFluentImpl.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
  }
  public BuildDefaultsFluentImpl.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildDefaultsFluentImpl that = (BuildDefaultsFluentImpl) o;
    if (!java.util.Objects.equals(defaultProxy, that.defaultProxy)) return false;

    if (!java.util.Objects.equals(env, that.env)) return false;

    if (!java.util.Objects.equals(gitProxy, that.gitProxy)) return false;

    if (!java.util.Objects.equals(imageLabels, that.imageLabels)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(defaultProxy,  env,  gitProxy,  imageLabels,  resources,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (defaultProxy != null) { sb.append("defaultProxy:"); sb.append(defaultProxy + ","); }
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (gitProxy != null) { sb.append("gitProxy:"); sb.append(gitProxy + ","); }
    if (imageLabels != null) { sb.append("imageLabels:"); sb.append(imageLabels + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DefaultProxyNestedImpl<N> extends ProxySpecFluentImpl<BuildDefaultsFluentImpl.DefaultProxyNested<N>> implements BuildDefaultsFluentImpl.DefaultProxyNested<N>,Nested<N>{
    DefaultProxyNestedImpl(ProxySpec item) {
      this.builder = new ProxySpecBuilder(this, item);
    }
    DefaultProxyNestedImpl() {
      this.builder = new ProxySpecBuilder(this);
    }
    ProxySpecBuilder builder;
    public N and() {
      return (N) BuildDefaultsFluentImpl.this.withDefaultProxy(builder.build());
    }
    public N endDefaultProxy() {
      return and();
    }
    
  }
  class GitProxyNestedImpl<N> extends ProxySpecFluentImpl<BuildDefaultsFluentImpl.GitProxyNested<N>> implements BuildDefaultsFluentImpl.GitProxyNested<N>,Nested<N>{
    GitProxyNestedImpl(ProxySpec item) {
      this.builder = new ProxySpecBuilder(this, item);
    }
    GitProxyNestedImpl() {
      this.builder = new ProxySpecBuilder(this);
    }
    ProxySpecBuilder builder;
    public N and() {
      return (N) BuildDefaultsFluentImpl.this.withGitProxy(builder.build());
    }
    public N endGitProxy() {
      return and();
    }
    
  }
  class ImageLabelsNestedImpl<N> extends ImageLabelFluentImpl<BuildDefaultsFluentImpl.ImageLabelsNested<N>> implements BuildDefaultsFluentImpl.ImageLabelsNested<N>,Nested<N>{
    ImageLabelsNestedImpl(int index,ImageLabel item) {
      this.index = index;
      this.builder = new ImageLabelBuilder(this, item);
    }
    ImageLabelsNestedImpl() {
      this.index = -1;
      this.builder = new ImageLabelBuilder(this);
    }
    ImageLabelBuilder builder;
    int index;
    public N and() {
      return (N) BuildDefaultsFluentImpl.this.setToImageLabels(index,builder.build());
    }
    public N endImageLabel() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<BuildDefaultsFluentImpl.ResourcesNested<N>> implements BuildDefaultsFluentImpl.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) BuildDefaultsFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  
}