package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BasicAuthIdentityProviderFluentImpl<A extends BasicAuthIdentityProviderFluent<A>> extends BaseFluent<A> implements BasicAuthIdentityProviderFluent<A>{
  public BasicAuthIdentityProviderFluentImpl() {
  }
  public BasicAuthIdentityProviderFluentImpl(BasicAuthIdentityProvider instance) {
    if (instance != null) {
      this.withCa(instance.getCa());
      this.withTlsClientCert(instance.getTlsClientCert());
      this.withTlsClientKey(instance.getTlsClientKey());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ConfigMapNameReferenceBuilder ca;
  private SecretNameReferenceBuilder tlsClientCert;
  private SecretNameReferenceBuilder tlsClientKey;
  private String url;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCa instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapNameReference getCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public ConfigMapNameReference buildCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public A withCa(ConfigMapNameReference ca) {
    _visitables.get("ca").remove(this.ca);
    if (ca!=null){ this.ca= new ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} else { this.ca = null; _visitables.get("ca").remove(this.ca); } return (A) this;
  }
  public Boolean hasCa() {
    return this.ca != null;
  }
  public A withNewCa(String name) {
    return (A)withCa(new ConfigMapNameReference(name));
  }
  public BasicAuthIdentityProviderFluentImpl.CaNested<A> withNewCa() {
    return new BasicAuthIdentityProviderFluentImpl.CaNestedImpl();
  }
  public BasicAuthIdentityProviderFluentImpl.CaNested<A> withNewCaLike(ConfigMapNameReference item) {
    return new BasicAuthIdentityProviderFluentImpl.CaNestedImpl(item);
  }
  public BasicAuthIdentityProviderFluentImpl.CaNested<A> editCa() {
    return withNewCaLike(getCa());
  }
  public BasicAuthIdentityProviderFluentImpl.CaNested<A> editOrNewCa() {
    return withNewCaLike(getCa() != null ? getCa(): new ConfigMapNameReferenceBuilder().build());
  }
  public BasicAuthIdentityProviderFluentImpl.CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
    return withNewCaLike(getCa() != null ? getCa(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTlsClientCert instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretNameReference getTlsClientCert() {
    return this.tlsClientCert!=null ?this.tlsClientCert.build():null;
  }
  public SecretNameReference buildTlsClientCert() {
    return this.tlsClientCert!=null ?this.tlsClientCert.build():null;
  }
  public A withTlsClientCert(SecretNameReference tlsClientCert) {
    _visitables.get("tlsClientCert").remove(this.tlsClientCert);
    if (tlsClientCert!=null){ this.tlsClientCert= new SecretNameReferenceBuilder(tlsClientCert); _visitables.get("tlsClientCert").add(this.tlsClientCert);} else { this.tlsClientCert = null; _visitables.get("tlsClientCert").remove(this.tlsClientCert); } return (A) this;
  }
  public Boolean hasTlsClientCert() {
    return this.tlsClientCert != null;
  }
  public A withNewTlsClientCert(String name) {
    return (A)withTlsClientCert(new SecretNameReference(name));
  }
  public BasicAuthIdentityProviderFluentImpl.TlsClientCertNested<A> withNewTlsClientCert() {
    return new BasicAuthIdentityProviderFluentImpl.TlsClientCertNestedImpl();
  }
  public BasicAuthIdentityProviderFluentImpl.TlsClientCertNested<A> withNewTlsClientCertLike(SecretNameReference item) {
    return new BasicAuthIdentityProviderFluentImpl.TlsClientCertNestedImpl(item);
  }
  public BasicAuthIdentityProviderFluentImpl.TlsClientCertNested<A> editTlsClientCert() {
    return withNewTlsClientCertLike(getTlsClientCert());
  }
  public BasicAuthIdentityProviderFluentImpl.TlsClientCertNested<A> editOrNewTlsClientCert() {
    return withNewTlsClientCertLike(getTlsClientCert() != null ? getTlsClientCert(): new SecretNameReferenceBuilder().build());
  }
  public BasicAuthIdentityProviderFluentImpl.TlsClientCertNested<A> editOrNewTlsClientCertLike(SecretNameReference item) {
    return withNewTlsClientCertLike(getTlsClientCert() != null ? getTlsClientCert(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTlsClientKey instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretNameReference getTlsClientKey() {
    return this.tlsClientKey!=null ?this.tlsClientKey.build():null;
  }
  public SecretNameReference buildTlsClientKey() {
    return this.tlsClientKey!=null ?this.tlsClientKey.build():null;
  }
  public A withTlsClientKey(SecretNameReference tlsClientKey) {
    _visitables.get("tlsClientKey").remove(this.tlsClientKey);
    if (tlsClientKey!=null){ this.tlsClientKey= new SecretNameReferenceBuilder(tlsClientKey); _visitables.get("tlsClientKey").add(this.tlsClientKey);} else { this.tlsClientKey = null; _visitables.get("tlsClientKey").remove(this.tlsClientKey); } return (A) this;
  }
  public Boolean hasTlsClientKey() {
    return this.tlsClientKey != null;
  }
  public A withNewTlsClientKey(String name) {
    return (A)withTlsClientKey(new SecretNameReference(name));
  }
  public BasicAuthIdentityProviderFluentImpl.TlsClientKeyNested<A> withNewTlsClientKey() {
    return new BasicAuthIdentityProviderFluentImpl.TlsClientKeyNestedImpl();
  }
  public BasicAuthIdentityProviderFluentImpl.TlsClientKeyNested<A> withNewTlsClientKeyLike(SecretNameReference item) {
    return new BasicAuthIdentityProviderFluentImpl.TlsClientKeyNestedImpl(item);
  }
  public BasicAuthIdentityProviderFluentImpl.TlsClientKeyNested<A> editTlsClientKey() {
    return withNewTlsClientKeyLike(getTlsClientKey());
  }
  public BasicAuthIdentityProviderFluentImpl.TlsClientKeyNested<A> editOrNewTlsClientKey() {
    return withNewTlsClientKeyLike(getTlsClientKey() != null ? getTlsClientKey(): new SecretNameReferenceBuilder().build());
  }
  public BasicAuthIdentityProviderFluentImpl.TlsClientKeyNested<A> editOrNewTlsClientKeyLike(SecretNameReference item) {
    return withNewTlsClientKeyLike(getTlsClientKey() != null ? getTlsClientKey(): item);
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BasicAuthIdentityProviderFluentImpl that = (BasicAuthIdentityProviderFluentImpl) o;
    if (!java.util.Objects.equals(ca, that.ca)) return false;

    if (!java.util.Objects.equals(tlsClientCert, that.tlsClientCert)) return false;

    if (!java.util.Objects.equals(tlsClientKey, that.tlsClientKey)) return false;

    if (!java.util.Objects.equals(url, that.url)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ca,  tlsClientCert,  tlsClientKey,  url,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (tlsClientCert != null) { sb.append("tlsClientCert:"); sb.append(tlsClientCert + ","); }
    if (tlsClientKey != null) { sb.append("tlsClientKey:"); sb.append(tlsClientKey + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CaNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<BasicAuthIdentityProviderFluentImpl.CaNested<N>> implements BasicAuthIdentityProviderFluentImpl.CaNested<N>,Nested<N>{
    CaNestedImpl(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    CaNestedImpl() {
      this.builder = new ConfigMapNameReferenceBuilder(this);
    }
    ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) BasicAuthIdentityProviderFluentImpl.this.withCa(builder.build());
    }
    public N endCa() {
      return and();
    }
    
  }
  class TlsClientCertNestedImpl<N> extends SecretNameReferenceFluentImpl<BasicAuthIdentityProviderFluentImpl.TlsClientCertNested<N>> implements BasicAuthIdentityProviderFluentImpl.TlsClientCertNested<N>,Nested<N>{
    TlsClientCertNestedImpl(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    TlsClientCertNestedImpl() {
      this.builder = new SecretNameReferenceBuilder(this);
    }
    SecretNameReferenceBuilder builder;
    public N and() {
      return (N) BasicAuthIdentityProviderFluentImpl.this.withTlsClientCert(builder.build());
    }
    public N endTlsClientCert() {
      return and();
    }
    
  }
  class TlsClientKeyNestedImpl<N> extends SecretNameReferenceFluentImpl<BasicAuthIdentityProviderFluentImpl.TlsClientKeyNested<N>> implements BasicAuthIdentityProviderFluentImpl.TlsClientKeyNested<N>,Nested<N>{
    TlsClientKeyNestedImpl(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    TlsClientKeyNestedImpl() {
      this.builder = new SecretNameReferenceBuilder(this);
    }
    SecretNameReferenceBuilder builder;
    public N and() {
      return (N) BasicAuthIdentityProviderFluentImpl.this.withTlsClientKey(builder.build());
    }
    public N endTlsClientKey() {
      return and();
    }
    
  }
  
}