package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzurePlatformSpecBuilder extends AzurePlatformSpecFluentImpl<AzurePlatformSpecBuilder> implements VisitableBuilder<AzurePlatformSpec,AzurePlatformSpecBuilder>{
  public AzurePlatformSpecBuilder() {
    this(false);
  }
  public AzurePlatformSpecBuilder(Boolean validationEnabled) {
    this(new AzurePlatformSpec(), validationEnabled);
  }
  public AzurePlatformSpecBuilder(AzurePlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AzurePlatformSpecBuilder(AzurePlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AzurePlatformSpec(), validationEnabled);
  }
  public AzurePlatformSpecBuilder(AzurePlatformSpecFluent<?> fluent,AzurePlatformSpec instance) {
    this(fluent, instance, false);
  }
  public AzurePlatformSpecBuilder(AzurePlatformSpecFluent<?> fluent,AzurePlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AzurePlatformSpecBuilder(AzurePlatformSpec instance) {
    this(instance,false);
  }
  public AzurePlatformSpecBuilder(AzurePlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AzurePlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AzurePlatformSpec build() {
    AzurePlatformSpec buildable = new AzurePlatformSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}