package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSServiceEndpointBuilder extends AWSServiceEndpointFluentImpl<AWSServiceEndpointBuilder> implements VisitableBuilder<AWSServiceEndpoint,AWSServiceEndpointBuilder>{
  public AWSServiceEndpointBuilder() {
    this(false);
  }
  public AWSServiceEndpointBuilder(Boolean validationEnabled) {
    this(new AWSServiceEndpoint(), validationEnabled);
  }
  public AWSServiceEndpointBuilder(AWSServiceEndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSServiceEndpointBuilder(AWSServiceEndpointFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSServiceEndpoint(), validationEnabled);
  }
  public AWSServiceEndpointBuilder(AWSServiceEndpointFluent<?> fluent,AWSServiceEndpoint instance) {
    this(fluent, instance, false);
  }
  public AWSServiceEndpointBuilder(AWSServiceEndpointFluent<?> fluent,AWSServiceEndpoint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withUrl(instance.getUrl());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSServiceEndpointBuilder(AWSServiceEndpoint instance) {
    this(instance,false);
  }
  public AWSServiceEndpointBuilder(AWSServiceEndpoint instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSServiceEndpointFluent<?> fluent;
  Boolean validationEnabled;
  public AWSServiceEndpoint build() {
    AWSServiceEndpoint buildable = new AWSServiceEndpoint(fluent.getName(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}