package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AWSPlatformStatusFluentImpl<A extends AWSPlatformStatusFluent<A>> extends BaseFluent<A> implements AWSPlatformStatusFluent<A>{
  public AWSPlatformStatusFluentImpl() {
  }
  public AWSPlatformStatusFluentImpl(AWSPlatformStatus instance) {
    if (instance != null) {
      this.withRegion(instance.getRegion());
      this.withResourceTags(instance.getResourceTags());
      this.withServiceEndpoints(instance.getServiceEndpoints());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String region;
  private ArrayList<AWSResourceTagBuilder> resourceTags = new ArrayList<AWSResourceTagBuilder>();
  private ArrayList<AWSServiceEndpointBuilder> serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
  private Map<String,Object> additionalProperties;
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public A addToResourceTags(int index,AWSResourceTag item) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AWSResourceTagBuilder>();}
    AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
    if (index < 0 || index >= resourceTags.size()) { _visitables.get("resourceTags").add(builder); resourceTags.add(builder); } else { _visitables.get("resourceTags").add(index, builder); resourceTags.add(index, builder);}
    return (A)this;
  }
  public A setToResourceTags(int index,AWSResourceTag item) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AWSResourceTagBuilder>();}
    AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
    if (index < 0 || index >= resourceTags.size()) { _visitables.get("resourceTags").add(builder); resourceTags.add(builder); } else { _visitables.get("resourceTags").set(index, builder); resourceTags.set(index, builder);}
    return (A)this;
  }
  public A addToResourceTags(io.fabric8.openshift.api.model.config.v1.AWSResourceTag... items) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AWSResourceTagBuilder>();}
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("resourceTags").add(builder);this.resourceTags.add(builder);} return (A)this;
  }
  public A addAllToResourceTags(Collection<AWSResourceTag> items) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AWSResourceTagBuilder>();}
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("resourceTags").add(builder);this.resourceTags.add(builder);} return (A)this;
  }
  public A removeFromResourceTags(io.fabric8.openshift.api.model.config.v1.AWSResourceTag... items) {
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("resourceTags").remove(builder);if (this.resourceTags != null) {this.resourceTags.remove(builder);}} return (A)this;
  }
  public A removeAllFromResourceTags(Collection<AWSResourceTag> items) {
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("resourceTags").remove(builder);if (this.resourceTags != null) {this.resourceTags.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResourceTags(Predicate<AWSResourceTagBuilder> predicate) {
    if (resourceTags == null) return (A) this;
    final Iterator<AWSResourceTagBuilder> each = resourceTags.iterator();
    final List visitables = _visitables.get("resourceTags");
    while (each.hasNext()) {
      AWSResourceTagBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResourceTags instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AWSResourceTag> getResourceTags() {
    return resourceTags != null ? build(resourceTags) : null;
  }
  public List<AWSResourceTag> buildResourceTags() {
    return resourceTags != null ? build(resourceTags) : null;
  }
  public AWSResourceTag buildResourceTag(int index) {
    return this.resourceTags.get(index).build();
  }
  public AWSResourceTag buildFirstResourceTag() {
    return this.resourceTags.get(0).build();
  }
  public AWSResourceTag buildLastResourceTag() {
    return this.resourceTags.get(resourceTags.size() - 1).build();
  }
  public AWSResourceTag buildMatchingResourceTag(Predicate<AWSResourceTagBuilder> predicate) {
    for (AWSResourceTagBuilder item: resourceTags) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingResourceTag(Predicate<AWSResourceTagBuilder> predicate) {
    for (AWSResourceTagBuilder item: resourceTags) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResourceTags(List<AWSResourceTag> resourceTags) {
    if (this.resourceTags != null) { _visitables.get("resourceTags").clear();}
    if (resourceTags != null) {this.resourceTags = new ArrayList(); for (AWSResourceTag item : resourceTags){this.addToResourceTags(item);}} else { this.resourceTags = null;} return (A) this;
  }
  public A withResourceTags(io.fabric8.openshift.api.model.config.v1.AWSResourceTag... resourceTags) {
    if (this.resourceTags != null) {this.resourceTags.clear(); _visitables.remove("resourceTags"); }
    if (resourceTags != null) {for (AWSResourceTag item :resourceTags){ this.addToResourceTags(item);}} return (A) this;
  }
  public Boolean hasResourceTags() {
    return resourceTags != null && !resourceTags.isEmpty();
  }
  public A addNewResourceTag(String key,String value) {
    return (A)addToResourceTags(new AWSResourceTag(key, value));
  }
  public AWSPlatformStatusFluentImpl.ResourceTagsNested<A> addNewResourceTag() {
    return new AWSPlatformStatusFluentImpl.ResourceTagsNestedImpl();
  }
  public AWSPlatformStatusFluentImpl.ResourceTagsNested<A> addNewResourceTagLike(AWSResourceTag item) {
    return new AWSPlatformStatusFluentImpl.ResourceTagsNestedImpl(-1, item);
  }
  public AWSPlatformStatusFluentImpl.ResourceTagsNested<A> setNewResourceTagLike(int index,AWSResourceTag item) {
    return new AWSPlatformStatusFluentImpl.ResourceTagsNestedImpl(index, item);
  }
  public AWSPlatformStatusFluentImpl.ResourceTagsNested<A> editResourceTag(int index) {
    if (resourceTags.size() <= index) throw new RuntimeException("Can't edit resourceTags. Index exceeds size.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  public AWSPlatformStatusFluentImpl.ResourceTagsNested<A> editFirstResourceTag() {
    if (resourceTags.size() == 0) throw new RuntimeException("Can't edit first resourceTags. The list is empty.");
    return setNewResourceTagLike(0, buildResourceTag(0));
  }
  public AWSPlatformStatusFluentImpl.ResourceTagsNested<A> editLastResourceTag() {
    int index = resourceTags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceTags. The list is empty.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  public AWSPlatformStatusFluentImpl.ResourceTagsNested<A> editMatchingResourceTag(Predicate<AWSResourceTagBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceTags.size();i++) { 
    if (predicate.test(resourceTags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceTags. No match found.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  public A addToServiceEndpoints(int index,AWSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
    AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
    if (index < 0 || index >= serviceEndpoints.size()) { _visitables.get("serviceEndpoints").add(builder); serviceEndpoints.add(builder); } else { _visitables.get("serviceEndpoints").add(index, builder); serviceEndpoints.add(index, builder);}
    return (A)this;
  }
  public A setToServiceEndpoints(int index,AWSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
    AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
    if (index < 0 || index >= serviceEndpoints.size()) { _visitables.get("serviceEndpoints").add(builder); serviceEndpoints.add(builder); } else { _visitables.get("serviceEndpoints").set(index, builder); serviceEndpoints.set(index, builder);}
    return (A)this;
  }
  public A addToServiceEndpoints(io.fabric8.openshift.api.model.config.v1.AWSServiceEndpoint... items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
    for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  public A addAllToServiceEndpoints(Collection<AWSServiceEndpoint> items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
    for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  public A removeFromServiceEndpoints(io.fabric8.openshift.api.model.config.v1.AWSServiceEndpoint... items) {
    for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceEndpoints(Collection<AWSServiceEndpoint> items) {
    for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceEndpoints(Predicate<AWSServiceEndpointBuilder> predicate) {
    if (serviceEndpoints == null) return (A) this;
    final Iterator<AWSServiceEndpointBuilder> each = serviceEndpoints.iterator();
    final List visitables = _visitables.get("serviceEndpoints");
    while (each.hasNext()) {
      AWSServiceEndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServiceEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AWSServiceEndpoint> getServiceEndpoints() {
    return serviceEndpoints != null ? build(serviceEndpoints) : null;
  }
  public List<AWSServiceEndpoint> buildServiceEndpoints() {
    return serviceEndpoints != null ? build(serviceEndpoints) : null;
  }
  public AWSServiceEndpoint buildServiceEndpoint(int index) {
    return this.serviceEndpoints.get(index).build();
  }
  public AWSServiceEndpoint buildFirstServiceEndpoint() {
    return this.serviceEndpoints.get(0).build();
  }
  public AWSServiceEndpoint buildLastServiceEndpoint() {
    return this.serviceEndpoints.get(serviceEndpoints.size() - 1).build();
  }
  public AWSServiceEndpoint buildMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
    for (AWSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
    for (AWSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceEndpoints(List<AWSServiceEndpoint> serviceEndpoints) {
    if (this.serviceEndpoints != null) { _visitables.get("serviceEndpoints").clear();}
    if (serviceEndpoints != null) {this.serviceEndpoints = new ArrayList(); for (AWSServiceEndpoint item : serviceEndpoints){this.addToServiceEndpoints(item);}} else { this.serviceEndpoints = null;} return (A) this;
  }
  public A withServiceEndpoints(io.fabric8.openshift.api.model.config.v1.AWSServiceEndpoint... serviceEndpoints) {
    if (this.serviceEndpoints != null) {this.serviceEndpoints.clear(); _visitables.remove("serviceEndpoints"); }
    if (serviceEndpoints != null) {for (AWSServiceEndpoint item :serviceEndpoints){ this.addToServiceEndpoints(item);}} return (A) this;
  }
  public Boolean hasServiceEndpoints() {
    return serviceEndpoints != null && !serviceEndpoints.isEmpty();
  }
  public A addNewServiceEndpoint(String name,String url) {
    return (A)addToServiceEndpoints(new AWSServiceEndpoint(name, url));
  }
  public AWSPlatformStatusFluentImpl.ServiceEndpointsNested<A> addNewServiceEndpoint() {
    return new AWSPlatformStatusFluentImpl.ServiceEndpointsNestedImpl();
  }
  public AWSPlatformStatusFluentImpl.ServiceEndpointsNested<A> addNewServiceEndpointLike(AWSServiceEndpoint item) {
    return new AWSPlatformStatusFluentImpl.ServiceEndpointsNestedImpl(-1, item);
  }
  public AWSPlatformStatusFluentImpl.ServiceEndpointsNested<A> setNewServiceEndpointLike(int index,AWSServiceEndpoint item) {
    return new AWSPlatformStatusFluentImpl.ServiceEndpointsNestedImpl(index, item);
  }
  public AWSPlatformStatusFluentImpl.ServiceEndpointsNested<A> editServiceEndpoint(int index) {
    if (serviceEndpoints.size() <= index) throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public AWSPlatformStatusFluentImpl.ServiceEndpointsNested<A> editFirstServiceEndpoint() {
    if (serviceEndpoints.size() == 0) throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(0, buildServiceEndpoint(0));
  }
  public AWSPlatformStatusFluentImpl.ServiceEndpointsNested<A> editLastServiceEndpoint() {
    int index = serviceEndpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public AWSPlatformStatusFluentImpl.ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<serviceEndpoints.size();i++) { 
    if (predicate.test(serviceEndpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSPlatformStatusFluentImpl that = (AWSPlatformStatusFluentImpl) o;
    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(resourceTags, that.resourceTags)) return false;

    if (!java.util.Objects.equals(serviceEndpoints, that.serviceEndpoints)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(region,  resourceTags,  serviceEndpoints,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (resourceTags != null) { sb.append("resourceTags:"); sb.append(resourceTags + ","); }
    if (serviceEndpoints != null) { sb.append("serviceEndpoints:"); sb.append(serviceEndpoints + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ResourceTagsNestedImpl<N> extends AWSResourceTagFluentImpl<AWSPlatformStatusFluentImpl.ResourceTagsNested<N>> implements AWSPlatformStatusFluentImpl.ResourceTagsNested<N>,Nested<N>{
    ResourceTagsNestedImpl(int index,AWSResourceTag item) {
      this.index = index;
      this.builder = new AWSResourceTagBuilder(this, item);
    }
    ResourceTagsNestedImpl() {
      this.index = -1;
      this.builder = new AWSResourceTagBuilder(this);
    }
    AWSResourceTagBuilder builder;
    int index;
    public N and() {
      return (N) AWSPlatformStatusFluentImpl.this.setToResourceTags(index,builder.build());
    }
    public N endResourceTag() {
      return and();
    }
    
  }
  class ServiceEndpointsNestedImpl<N> extends AWSServiceEndpointFluentImpl<AWSPlatformStatusFluentImpl.ServiceEndpointsNested<N>> implements AWSPlatformStatusFluentImpl.ServiceEndpointsNested<N>,Nested<N>{
    ServiceEndpointsNestedImpl(int index,AWSServiceEndpoint item) {
      this.index = index;
      this.builder = new AWSServiceEndpointBuilder(this, item);
    }
    ServiceEndpointsNestedImpl() {
      this.index = -1;
      this.builder = new AWSServiceEndpointBuilder(this);
    }
    AWSServiceEndpointBuilder builder;
    int index;
    public N and() {
      return (N) AWSPlatformStatusFluentImpl.this.setToServiceEndpoints(index,builder.build());
    }
    public N endServiceEndpoint() {
      return and();
    }
    
  }
  
}