package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSPlatformStatusBuilder extends AWSPlatformStatusFluentImpl<AWSPlatformStatusBuilder> implements VisitableBuilder<AWSPlatformStatus,AWSPlatformStatusBuilder>{
  public AWSPlatformStatusBuilder() {
    this(false);
  }
  public AWSPlatformStatusBuilder(Boolean validationEnabled) {
    this(new AWSPlatformStatus(), validationEnabled);
  }
  public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSPlatformStatus(), validationEnabled);
  }
  public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent,AWSPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent,AWSPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withRegion(instance.getRegion());
      fluent.withResourceTags(instance.getResourceTags());
      fluent.withServiceEndpoints(instance.getServiceEndpoints());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSPlatformStatusBuilder(AWSPlatformStatus instance) {
    this(instance,false);
  }
  public AWSPlatformStatusBuilder(AWSPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withRegion(instance.getRegion());
      this.withResourceTags(instance.getResourceTags());
      this.withServiceEndpoints(instance.getServiceEndpoints());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSPlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AWSPlatformStatus build() {
    AWSPlatformStatus buildable = new AWSPlatformStatus(fluent.getRegion(),fluent.getResourceTags(),fluent.getServiceEndpoints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}