package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface APIServerFluent<A extends APIServerFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public APIServerFluent.MetadataNested<A> withNewMetadata();
  public APIServerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public APIServerFluent.MetadataNested<A> editMetadata();
  public APIServerFluent.MetadataNested<A> editOrNewMetadata();
  public APIServerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIServerSpec getSpec();
  public APIServerSpec buildSpec();
  public A withSpec(APIServerSpec spec);
  public Boolean hasSpec();
  public APIServerFluent.SpecNested<A> withNewSpec();
  public APIServerFluent.SpecNested<A> withNewSpecLike(APIServerSpec item);
  public APIServerFluent.SpecNested<A> editSpec();
  public APIServerFluent.SpecNested<A> editOrNewSpec();
  public APIServerFluent.SpecNested<A> editOrNewSpecLike(APIServerSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIServerStatus getStatus();
  public APIServerStatus buildStatus();
  public A withStatus(APIServerStatus status);
  public Boolean hasStatus();
  public APIServerFluent.StatusNested<A> withNewStatus();
  public APIServerFluent.StatusNested<A> withNewStatusLike(APIServerStatus item);
  public APIServerFluent.StatusNested<A> editStatus();
  public APIServerFluent.StatusNested<A> editOrNewStatus();
  public APIServerFluent.StatusNested<A> editOrNewStatusLike(APIServerStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<APIServerFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,APIServerSpecFluent<APIServerFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,APIServerStatusFluent<APIServerFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}