package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProjectSpecFluentImpl<A extends ProjectSpecFluent<A>> extends BaseFluent<A> implements ProjectSpecFluent<A>{
  public ProjectSpecFluentImpl() {
  }
  public ProjectSpecFluentImpl(ProjectSpec instance) {
    this.withProjectRequestMessage(instance.getProjectRequestMessage()); 
    this.withProjectRequestTemplate(instance.getProjectRequestTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String projectRequestMessage;
  private TemplateReferenceBuilder projectRequestTemplate;
  private Map<String,Object> additionalProperties;
  public String getProjectRequestMessage() {
    return this.projectRequestMessage;
  }
  public A withProjectRequestMessage(String projectRequestMessage) {
    this.projectRequestMessage=projectRequestMessage; return (A) this;
  }
  public Boolean hasProjectRequestMessage() {
    return this.projectRequestMessage != null;
  }
  
  /**
   * This method has been deprecated, please use method buildProjectRequestTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public TemplateReference getProjectRequestTemplate() {
    return this.projectRequestTemplate!=null ?this.projectRequestTemplate.build():null;
  }
  public TemplateReference buildProjectRequestTemplate() {
    return this.projectRequestTemplate!=null ?this.projectRequestTemplate.build():null;
  }
  public A withProjectRequestTemplate(TemplateReference projectRequestTemplate) {
    _visitables.get("projectRequestTemplate").remove(this.projectRequestTemplate);
    if (projectRequestTemplate!=null){ this.projectRequestTemplate= new TemplateReferenceBuilder(projectRequestTemplate); _visitables.get("projectRequestTemplate").add(this.projectRequestTemplate);} else { this.projectRequestTemplate = null; _visitables.get("projectRequestTemplate").remove(this.projectRequestTemplate); } return (A) this;
  }
  public Boolean hasProjectRequestTemplate() {
    return this.projectRequestTemplate != null;
  }
  public A withNewProjectRequestTemplate(String name) {
    return (A)withProjectRequestTemplate(new TemplateReference(name));
  }
  public ProjectSpecFluent.ProjectRequestTemplateNested<A> withNewProjectRequestTemplate() {
    return new ProjectSpecFluentImpl.ProjectRequestTemplateNestedImpl();
  }
  public ProjectSpecFluent.ProjectRequestTemplateNested<A> withNewProjectRequestTemplateLike(TemplateReference item) {
    return new ProjectSpecFluentImpl.ProjectRequestTemplateNestedImpl(item);
  }
  public ProjectSpecFluent.ProjectRequestTemplateNested<A> editProjectRequestTemplate() {
    return withNewProjectRequestTemplateLike(getProjectRequestTemplate());
  }
  public ProjectSpecFluent.ProjectRequestTemplateNested<A> editOrNewProjectRequestTemplate() {
    return withNewProjectRequestTemplateLike(getProjectRequestTemplate() != null ? getProjectRequestTemplate(): new TemplateReferenceBuilder().build());
  }
  public ProjectSpecFluent.ProjectRequestTemplateNested<A> editOrNewProjectRequestTemplateLike(TemplateReference item) {
    return withNewProjectRequestTemplateLike(getProjectRequestTemplate() != null ? getProjectRequestTemplate(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProjectSpecFluentImpl that = (ProjectSpecFluentImpl) o;
    if (projectRequestMessage != null ? !projectRequestMessage.equals(that.projectRequestMessage) :that.projectRequestMessage != null) return false;
    if (projectRequestTemplate != null ? !projectRequestTemplate.equals(that.projectRequestTemplate) :that.projectRequestTemplate != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(projectRequestMessage,  projectRequestTemplate,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (projectRequestMessage != null) { sb.append("projectRequestMessage:"); sb.append(projectRequestMessage + ","); }
    if (projectRequestTemplate != null) { sb.append("projectRequestTemplate:"); sb.append(projectRequestTemplate + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ProjectRequestTemplateNestedImpl<N> extends TemplateReferenceFluentImpl<ProjectSpecFluent.ProjectRequestTemplateNested<N>> implements ProjectSpecFluent.ProjectRequestTemplateNested<N>,Nested<N>{
    ProjectRequestTemplateNestedImpl(TemplateReference item) {
      this.builder = new TemplateReferenceBuilder(this, item);
    }
    ProjectRequestTemplateNestedImpl() {
      this.builder = new TemplateReferenceBuilder(this);
    }
    TemplateReferenceBuilder builder;
    public N and() {
      return (N) ProjectSpecFluentImpl.this.withProjectRequestTemplate(builder.build());
    }
    public N endProjectRequestTemplate() {
      return and();
    }
    
  }
  
}