
package io.fabric8.openshift.api.model.config.v1;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "error",
    "login",
    "providerSelection"
})
@ToString
@EqualsAndHashCode
@Setter
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class OAuthTemplates implements KubernetesResource
{

    @JsonProperty("error")
    private SecretNameReference error;
    @JsonProperty("login")
    private SecretNameReference login;
    @JsonProperty("providerSelection")
    private SecretNameReference providerSelection;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public OAuthTemplates() {
    }

    /**
     * 
     * @param providerSelection
     * @param error
     * @param login
     */
    public OAuthTemplates(SecretNameReference error, SecretNameReference login, SecretNameReference providerSelection) {
        super();
        this.error = error;
        this.login = login;
        this.providerSelection = providerSelection;
    }

    @JsonProperty("error")
    public SecretNameReference getError() {
        return error;
    }

    @JsonProperty("error")
    public void setError(SecretNameReference error) {
        this.error = error;
    }

    @JsonProperty("login")
    public SecretNameReference getLogin() {
        return login;
    }

    @JsonProperty("login")
    public void setLogin(SecretNameReference login) {
        this.login = login;
    }

    @JsonProperty("providerSelection")
    public SecretNameReference getProviderSelection() {
        return providerSelection;
    }

    @JsonProperty("providerSelection")
    public void setProviderSelection(SecretNameReference providerSelection) {
        this.providerSelection = providerSelection;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
