package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AlibabaCloudResourceTagBuilder extends AlibabaCloudResourceTagFluentImpl<AlibabaCloudResourceTagBuilder> implements VisitableBuilder<AlibabaCloudResourceTag,AlibabaCloudResourceTagBuilder>{
  public AlibabaCloudResourceTagBuilder() {
    this(false);
  }
  public AlibabaCloudResourceTagBuilder(Boolean validationEnabled) {
    this(new AlibabaCloudResourceTag(), validationEnabled);
  }
  public AlibabaCloudResourceTagBuilder(AlibabaCloudResourceTagFluent<?> fluent) {
    this(fluent, false);
  }
  public AlibabaCloudResourceTagBuilder(AlibabaCloudResourceTagFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AlibabaCloudResourceTag(), validationEnabled);
  }
  public AlibabaCloudResourceTagBuilder(AlibabaCloudResourceTagFluent<?> fluent,AlibabaCloudResourceTag instance) {
    this(fluent, instance, false);
  }
  public AlibabaCloudResourceTagBuilder(AlibabaCloudResourceTagFluent<?> fluent,AlibabaCloudResourceTag instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKey(instance.getKey()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AlibabaCloudResourceTagBuilder(AlibabaCloudResourceTag instance) {
    this(instance,false);
  }
  public AlibabaCloudResourceTagBuilder(AlibabaCloudResourceTag instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withKey(instance.getKey()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AlibabaCloudResourceTagFluent<?> fluent;
  Boolean validationEnabled;
  public AlibabaCloudResourceTag build() {
    AlibabaCloudResourceTag buildable = new AlibabaCloudResourceTag(fluent.getKey(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}