package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretNameReferenceBuilder extends SecretNameReferenceFluentImpl<SecretNameReferenceBuilder> implements VisitableBuilder<SecretNameReference,SecretNameReferenceBuilder>{
  public SecretNameReferenceBuilder() {
    this(false);
  }
  public SecretNameReferenceBuilder(Boolean validationEnabled) {
    this(new SecretNameReference(), validationEnabled);
  }
  public SecretNameReferenceBuilder(SecretNameReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretNameReferenceBuilder(SecretNameReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretNameReference(), validationEnabled);
  }
  public SecretNameReferenceBuilder(SecretNameReferenceFluent<?> fluent,SecretNameReference instance) {
    this(fluent, instance, false);
  }
  public SecretNameReferenceBuilder(SecretNameReferenceFluent<?> fluent,SecretNameReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretNameReferenceBuilder(SecretNameReference instance) {
    this(instance,false);
  }
  public SecretNameReferenceBuilder(SecretNameReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SecretNameReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public SecretNameReference build() {
    SecretNameReference buildable = new SecretNameReference(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}