package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformSpecBuilder extends PlatformSpecFluentImpl<PlatformSpecBuilder> implements VisitableBuilder<PlatformSpec,PlatformSpecBuilder>{
  public PlatformSpecBuilder() {
    this(false);
  }
  public PlatformSpecBuilder(Boolean validationEnabled) {
    this(new PlatformSpec(), validationEnabled);
  }
  public PlatformSpecBuilder(PlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformSpecBuilder(PlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlatformSpec(), validationEnabled);
  }
  public PlatformSpecBuilder(PlatformSpecFluent<?> fluent,PlatformSpec instance) {
    this(fluent, instance, false);
  }
  public PlatformSpecBuilder(PlatformSpecFluent<?> fluent,PlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAlibabaCloud(instance.getAlibabaCloud()); 
    fluent.withAws(instance.getAws()); 
    fluent.withAzure(instance.getAzure()); 
    fluent.withBaremetal(instance.getBaremetal()); 
    fluent.withEquinixMetal(instance.getEquinixMetal()); 
    fluent.withGcp(instance.getGcp()); 
    fluent.withIbmcloud(instance.getIbmcloud()); 
    fluent.withKubevirt(instance.getKubevirt()); 
    fluent.withOpenstack(instance.getOpenstack()); 
    fluent.withOvirt(instance.getOvirt()); 
    fluent.withPowervs(instance.getPowervs()); 
    fluent.withType(instance.getType()); 
    fluent.withVsphere(instance.getVsphere()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformSpecBuilder(PlatformSpec instance) {
    this(instance,false);
  }
  public PlatformSpecBuilder(PlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAlibabaCloud(instance.getAlibabaCloud()); 
    this.withAws(instance.getAws()); 
    this.withAzure(instance.getAzure()); 
    this.withBaremetal(instance.getBaremetal()); 
    this.withEquinixMetal(instance.getEquinixMetal()); 
    this.withGcp(instance.getGcp()); 
    this.withIbmcloud(instance.getIbmcloud()); 
    this.withKubevirt(instance.getKubevirt()); 
    this.withOpenstack(instance.getOpenstack()); 
    this.withOvirt(instance.getOvirt()); 
    this.withPowervs(instance.getPowervs()); 
    this.withType(instance.getType()); 
    this.withVsphere(instance.getVsphere()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PlatformSpec build() {
    PlatformSpec buildable = new PlatformSpec(fluent.getAlibabaCloud(),fluent.getAws(),fluent.getAzure(),fluent.getBaremetal(),fluent.getEquinixMetal(),fluent.getGcp(),fluent.getIbmcloud(),fluent.getKubevirt(),fluent.getOpenstack(),fluent.getOvirt(),fluent.getPowervs(),fluent.getType(),fluent.getVsphere());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}