package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OpenStackPlatformStatusFluentImpl<A extends OpenStackPlatformStatusFluent<A>> extends BaseFluent<A> implements OpenStackPlatformStatusFluent<A>{
  public OpenStackPlatformStatusFluentImpl() {
  }
  public OpenStackPlatformStatusFluentImpl(OpenStackPlatformStatus instance) {
    this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    this.withCloudName(instance.getCloudName()); 
    this.withIngressIP(instance.getIngressIP()); 
    this.withNodeDNSIP(instance.getNodeDNSIP()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiServerInternalIP;
  private String cloudName;
  private String ingressIP;
  private String nodeDNSIP;
  private Map<String,Object> additionalProperties;
  public String getApiServerInternalIP() {
    return this.apiServerInternalIP;
  }
  public A withApiServerInternalIP(String apiServerInternalIP) {
    this.apiServerInternalIP=apiServerInternalIP; return (A) this;
  }
  public Boolean hasApiServerInternalIP() {
    return this.apiServerInternalIP != null;
  }
  public String getCloudName() {
    return this.cloudName;
  }
  public A withCloudName(String cloudName) {
    this.cloudName=cloudName; return (A) this;
  }
  public Boolean hasCloudName() {
    return this.cloudName != null;
  }
  public String getIngressIP() {
    return this.ingressIP;
  }
  public A withIngressIP(String ingressIP) {
    this.ingressIP=ingressIP; return (A) this;
  }
  public Boolean hasIngressIP() {
    return this.ingressIP != null;
  }
  public String getNodeDNSIP() {
    return this.nodeDNSIP;
  }
  public A withNodeDNSIP(String nodeDNSIP) {
    this.nodeDNSIP=nodeDNSIP; return (A) this;
  }
  public Boolean hasNodeDNSIP() {
    return this.nodeDNSIP != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OpenStackPlatformStatusFluentImpl that = (OpenStackPlatformStatusFluentImpl) o;
    if (apiServerInternalIP != null ? !apiServerInternalIP.equals(that.apiServerInternalIP) :that.apiServerInternalIP != null) return false;
    if (cloudName != null ? !cloudName.equals(that.cloudName) :that.cloudName != null) return false;
    if (ingressIP != null ? !ingressIP.equals(that.ingressIP) :that.ingressIP != null) return false;
    if (nodeDNSIP != null ? !nodeDNSIP.equals(that.nodeDNSIP) :that.nodeDNSIP != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiServerInternalIP,  cloudName,  ingressIP,  nodeDNSIP,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiServerInternalIP != null) { sb.append("apiServerInternalIP:"); sb.append(apiServerInternalIP + ","); }
    if (cloudName != null) { sb.append("cloudName:"); sb.append(cloudName + ","); }
    if (ingressIP != null) { sb.append("ingressIP:"); sb.append(ingressIP + ","); }
    if (nodeDNSIP != null) { sb.append("nodeDNSIP:"); sb.append(nodeDNSIP + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}