package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkListBuilder extends NetworkListFluentImpl<NetworkListBuilder> implements VisitableBuilder<NetworkList,NetworkListBuilder>{
  public NetworkListBuilder() {
    this(false);
  }
  public NetworkListBuilder(Boolean validationEnabled) {
    this(new NetworkList(), validationEnabled);
  }
  public NetworkListBuilder(NetworkListFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkListBuilder(NetworkListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkList(), validationEnabled);
  }
  public NetworkListBuilder(NetworkListFluent<?> fluent,NetworkList instance) {
    this(fluent, instance, false);
  }
  public NetworkListBuilder(NetworkListFluent<?> fluent,NetworkList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkListBuilder(NetworkList instance) {
    this(instance,false);
  }
  public NetworkListBuilder(NetworkList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  NetworkListFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkList build() {
    NetworkList buildable = new NetworkList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}