package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class LDAPIdentityProviderFluentImpl<A extends LDAPIdentityProviderFluent<A>> extends BaseFluent<A> implements LDAPIdentityProviderFluent<A>{
  public LDAPIdentityProviderFluentImpl() {
  }
  public LDAPIdentityProviderFluentImpl(LDAPIdentityProvider instance) {
    this.withAttributes(instance.getAttributes()); 
    this.withBindDN(instance.getBindDN()); 
    this.withBindPassword(instance.getBindPassword()); 
    this.withCa(instance.getCa()); 
    this.withInsecure(instance.getInsecure()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private LDAPAttributeMappingBuilder attributes;
  private String bindDN;
  private SecretNameReferenceBuilder bindPassword;
  private ConfigMapNameReferenceBuilder ca;
  private Boolean insecure;
  private String url;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAttributes instead.
   * @return The buildable object.
   */
  @Deprecated
  public LDAPAttributeMapping getAttributes() {
    return this.attributes!=null ?this.attributes.build():null;
  }
  public LDAPAttributeMapping buildAttributes() {
    return this.attributes!=null ?this.attributes.build():null;
  }
  public A withAttributes(LDAPAttributeMapping attributes) {
    _visitables.get("attributes").remove(this.attributes);
    if (attributes!=null){ this.attributes= new LDAPAttributeMappingBuilder(attributes); _visitables.get("attributes").add(this.attributes);} else { this.attributes = null; _visitables.get("attributes").remove(this.attributes); } return (A) this;
  }
  public Boolean hasAttributes() {
    return this.attributes != null;
  }
  public LDAPIdentityProviderFluent.AttributesNested<A> withNewAttributes() {
    return new LDAPIdentityProviderFluentImpl.AttributesNestedImpl();
  }
  public LDAPIdentityProviderFluent.AttributesNested<A> withNewAttributesLike(LDAPAttributeMapping item) {
    return new LDAPIdentityProviderFluentImpl.AttributesNestedImpl(item);
  }
  public LDAPIdentityProviderFluent.AttributesNested<A> editAttributes() {
    return withNewAttributesLike(getAttributes());
  }
  public LDAPIdentityProviderFluent.AttributesNested<A> editOrNewAttributes() {
    return withNewAttributesLike(getAttributes() != null ? getAttributes(): new LDAPAttributeMappingBuilder().build());
  }
  public LDAPIdentityProviderFluent.AttributesNested<A> editOrNewAttributesLike(LDAPAttributeMapping item) {
    return withNewAttributesLike(getAttributes() != null ? getAttributes(): item);
  }
  public String getBindDN() {
    return this.bindDN;
  }
  public A withBindDN(String bindDN) {
    this.bindDN=bindDN; return (A) this;
  }
  public Boolean hasBindDN() {
    return this.bindDN != null;
  }
  
  /**
   * This method has been deprecated, please use method buildBindPassword instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretNameReference getBindPassword() {
    return this.bindPassword!=null ?this.bindPassword.build():null;
  }
  public SecretNameReference buildBindPassword() {
    return this.bindPassword!=null ?this.bindPassword.build():null;
  }
  public A withBindPassword(SecretNameReference bindPassword) {
    _visitables.get("bindPassword").remove(this.bindPassword);
    if (bindPassword!=null){ this.bindPassword= new SecretNameReferenceBuilder(bindPassword); _visitables.get("bindPassword").add(this.bindPassword);} else { this.bindPassword = null; _visitables.get("bindPassword").remove(this.bindPassword); } return (A) this;
  }
  public Boolean hasBindPassword() {
    return this.bindPassword != null;
  }
  public A withNewBindPassword(String name) {
    return (A)withBindPassword(new SecretNameReference(name));
  }
  public LDAPIdentityProviderFluent.BindPasswordNested<A> withNewBindPassword() {
    return new LDAPIdentityProviderFluentImpl.BindPasswordNestedImpl();
  }
  public LDAPIdentityProviderFluent.BindPasswordNested<A> withNewBindPasswordLike(SecretNameReference item) {
    return new LDAPIdentityProviderFluentImpl.BindPasswordNestedImpl(item);
  }
  public LDAPIdentityProviderFluent.BindPasswordNested<A> editBindPassword() {
    return withNewBindPasswordLike(getBindPassword());
  }
  public LDAPIdentityProviderFluent.BindPasswordNested<A> editOrNewBindPassword() {
    return withNewBindPasswordLike(getBindPassword() != null ? getBindPassword(): new SecretNameReferenceBuilder().build());
  }
  public LDAPIdentityProviderFluent.BindPasswordNested<A> editOrNewBindPasswordLike(SecretNameReference item) {
    return withNewBindPasswordLike(getBindPassword() != null ? getBindPassword(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCa instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapNameReference getCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public ConfigMapNameReference buildCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public A withCa(ConfigMapNameReference ca) {
    _visitables.get("ca").remove(this.ca);
    if (ca!=null){ this.ca= new ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} else { this.ca = null; _visitables.get("ca").remove(this.ca); } return (A) this;
  }
  public Boolean hasCa() {
    return this.ca != null;
  }
  public A withNewCa(String name) {
    return (A)withCa(new ConfigMapNameReference(name));
  }
  public LDAPIdentityProviderFluent.CaNested<A> withNewCa() {
    return new LDAPIdentityProviderFluentImpl.CaNestedImpl();
  }
  public LDAPIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item) {
    return new LDAPIdentityProviderFluentImpl.CaNestedImpl(item);
  }
  public LDAPIdentityProviderFluent.CaNested<A> editCa() {
    return withNewCaLike(getCa());
  }
  public LDAPIdentityProviderFluent.CaNested<A> editOrNewCa() {
    return withNewCaLike(getCa() != null ? getCa(): new ConfigMapNameReferenceBuilder().build());
  }
  public LDAPIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
    return withNewCaLike(getCa() != null ? getCa(): item);
  }
  public Boolean getInsecure() {
    return this.insecure;
  }
  public A withInsecure(Boolean insecure) {
    this.insecure=insecure; return (A) this;
  }
  public Boolean hasInsecure() {
    return this.insecure != null;
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LDAPIdentityProviderFluentImpl that = (LDAPIdentityProviderFluentImpl) o;
    if (attributes != null ? !attributes.equals(that.attributes) :that.attributes != null) return false;
    if (bindDN != null ? !bindDN.equals(that.bindDN) :that.bindDN != null) return false;
    if (bindPassword != null ? !bindPassword.equals(that.bindPassword) :that.bindPassword != null) return false;
    if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
    if (insecure != null ? !insecure.equals(that.insecure) :that.insecure != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(attributes,  bindDN,  bindPassword,  ca,  insecure,  url,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attributes != null) { sb.append("attributes:"); sb.append(attributes + ","); }
    if (bindDN != null) { sb.append("bindDN:"); sb.append(bindDN + ","); }
    if (bindPassword != null) { sb.append("bindPassword:"); sb.append(bindPassword + ","); }
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (insecure != null) { sb.append("insecure:"); sb.append(insecure + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withInsecure() {
    return withInsecure(true);
  }
  class AttributesNestedImpl<N> extends LDAPAttributeMappingFluentImpl<LDAPIdentityProviderFluent.AttributesNested<N>> implements LDAPIdentityProviderFluent.AttributesNested<N>,Nested<N>{
    AttributesNestedImpl(LDAPAttributeMapping item) {
      this.builder = new LDAPAttributeMappingBuilder(this, item);
    }
    AttributesNestedImpl() {
      this.builder = new LDAPAttributeMappingBuilder(this);
    }
    LDAPAttributeMappingBuilder builder;
    public N and() {
      return (N) LDAPIdentityProviderFluentImpl.this.withAttributes(builder.build());
    }
    public N endAttributes() {
      return and();
    }
    
  }
  class BindPasswordNestedImpl<N> extends SecretNameReferenceFluentImpl<LDAPIdentityProviderFluent.BindPasswordNested<N>> implements LDAPIdentityProviderFluent.BindPasswordNested<N>,Nested<N>{
    BindPasswordNestedImpl(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    BindPasswordNestedImpl() {
      this.builder = new SecretNameReferenceBuilder(this);
    }
    SecretNameReferenceBuilder builder;
    public N and() {
      return (N) LDAPIdentityProviderFluentImpl.this.withBindPassword(builder.build());
    }
    public N endBindPassword() {
      return and();
    }
    
  }
  class CaNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<LDAPIdentityProviderFluent.CaNested<N>> implements LDAPIdentityProviderFluent.CaNested<N>,Nested<N>{
    CaNestedImpl(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    CaNestedImpl() {
      this.builder = new ConfigMapNameReferenceBuilder(this);
    }
    ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) LDAPIdentityProviderFluentImpl.this.withCa(builder.build());
    }
    public N endCa() {
      return and();
    }
    
  }
  
}