package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubevirtPlatformStatusBuilder extends KubevirtPlatformStatusFluentImpl<KubevirtPlatformStatusBuilder> implements VisitableBuilder<KubevirtPlatformStatus,KubevirtPlatformStatusBuilder>{
  public KubevirtPlatformStatusBuilder() {
    this(false);
  }
  public KubevirtPlatformStatusBuilder(Boolean validationEnabled) {
    this(new KubevirtPlatformStatus(), validationEnabled);
  }
  public KubevirtPlatformStatusBuilder(KubevirtPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KubevirtPlatformStatusBuilder(KubevirtPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubevirtPlatformStatus(), validationEnabled);
  }
  public KubevirtPlatformStatusBuilder(KubevirtPlatformStatusFluent<?> fluent,KubevirtPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public KubevirtPlatformStatusBuilder(KubevirtPlatformStatusFluent<?> fluent,KubevirtPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    fluent.withIngressIP(instance.getIngressIP()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KubevirtPlatformStatusBuilder(KubevirtPlatformStatus instance) {
    this(instance,false);
  }
  public KubevirtPlatformStatusBuilder(KubevirtPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    this.withIngressIP(instance.getIngressIP()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  KubevirtPlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KubevirtPlatformStatus build() {
    KubevirtPlatformStatus buildable = new KubevirtPlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}