package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressStatusFluentImpl<A extends IngressStatusFluent<A>> extends BaseFluent<A> implements IngressStatusFluent<A>{
  public IngressStatusFluentImpl() {
  }
  public IngressStatusFluentImpl(IngressStatus instance) {
    this.withComponentRoutes(instance.getComponentRoutes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ComponentRouteStatusBuilder> componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToComponentRoutes(Integer index,ComponentRouteStatus item) {
    if (this.componentRoutes == null) {this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();}
    ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);_visitables.get("componentRoutes").add(index >= 0 ? index : _visitables.get("componentRoutes").size(), builder);this.componentRoutes.add(index >= 0 ? index : componentRoutes.size(), builder); return (A)this;
  }
  public A setToComponentRoutes(Integer index,ComponentRouteStatus item) {
    if (this.componentRoutes == null) {this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();}
    ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("componentRoutes").size()) { _visitables.get("componentRoutes").add(builder); } else { _visitables.get("componentRoutes").set(index, builder);}
    if (index < 0 || index >= componentRoutes.size()) { componentRoutes.add(builder); } else { componentRoutes.set(index, builder);}
     return (A)this;
  }
  public A addToComponentRoutes(io.fabric8.openshift.api.model.config.v1.ComponentRouteStatus... items) {
    if (this.componentRoutes == null) {this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();}
    for (ComponentRouteStatus item : items) {ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);_visitables.get("componentRoutes").add(builder);this.componentRoutes.add(builder);} return (A)this;
  }
  public A addAllToComponentRoutes(Collection<ComponentRouteStatus> items) {
    if (this.componentRoutes == null) {this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();}
    for (ComponentRouteStatus item : items) {ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);_visitables.get("componentRoutes").add(builder);this.componentRoutes.add(builder);} return (A)this;
  }
  public A removeFromComponentRoutes(io.fabric8.openshift.api.model.config.v1.ComponentRouteStatus... items) {
    for (ComponentRouteStatus item : items) {ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);_visitables.get("componentRoutes").remove(builder);if (this.componentRoutes != null) {this.componentRoutes.remove(builder);}} return (A)this;
  }
  public A removeAllFromComponentRoutes(Collection<ComponentRouteStatus> items) {
    for (ComponentRouteStatus item : items) {ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);_visitables.get("componentRoutes").remove(builder);if (this.componentRoutes != null) {this.componentRoutes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromComponentRoutes(Predicate<ComponentRouteStatusBuilder> predicate) {
    if (componentRoutes == null) return (A) this;
    final Iterator<ComponentRouteStatusBuilder> each = componentRoutes.iterator();
    final List visitables = _visitables.get("componentRoutes");
    while (each.hasNext()) {
      ComponentRouteStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildComponentRoutes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ComponentRouteStatus> getComponentRoutes() {
    return componentRoutes != null ? build(componentRoutes) : null;
  }
  public List<ComponentRouteStatus> buildComponentRoutes() {
    return componentRoutes != null ? build(componentRoutes) : null;
  }
  public ComponentRouteStatus buildComponentRoute(Integer index) {
    return this.componentRoutes.get(index).build();
  }
  public ComponentRouteStatus buildFirstComponentRoute() {
    return this.componentRoutes.get(0).build();
  }
  public ComponentRouteStatus buildLastComponentRoute() {
    return this.componentRoutes.get(componentRoutes.size() - 1).build();
  }
  public ComponentRouteStatus buildMatchingComponentRoute(Predicate<ComponentRouteStatusBuilder> predicate) {
    for (ComponentRouteStatusBuilder item: componentRoutes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingComponentRoute(Predicate<ComponentRouteStatusBuilder> predicate) {
    for (ComponentRouteStatusBuilder item: componentRoutes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withComponentRoutes(List<ComponentRouteStatus> componentRoutes) {
    if (this.componentRoutes != null) { _visitables.get("componentRoutes").removeAll(this.componentRoutes);}
    if (componentRoutes != null) {this.componentRoutes = new ArrayList(); for (ComponentRouteStatus item : componentRoutes){this.addToComponentRoutes(item);}} else { this.componentRoutes = null;} return (A) this;
  }
  public A withComponentRoutes(io.fabric8.openshift.api.model.config.v1.ComponentRouteStatus... componentRoutes) {
    if (this.componentRoutes != null) {this.componentRoutes.clear();}
    if (componentRoutes != null) {for (ComponentRouteStatus item :componentRoutes){ this.addToComponentRoutes(item);}} return (A) this;
  }
  public Boolean hasComponentRoutes() {
    return componentRoutes != null && !componentRoutes.isEmpty();
  }
  public IngressStatusFluent.ComponentRoutesNested<A> addNewComponentRoute() {
    return new IngressStatusFluentImpl.ComponentRoutesNestedImpl();
  }
  public IngressStatusFluent.ComponentRoutesNested<A> addNewComponentRouteLike(ComponentRouteStatus item) {
    return new IngressStatusFluentImpl.ComponentRoutesNestedImpl(-1, item);
  }
  public IngressStatusFluent.ComponentRoutesNested<A> setNewComponentRouteLike(Integer index,ComponentRouteStatus item) {
    return new IngressStatusFluentImpl.ComponentRoutesNestedImpl(index, item);
  }
  public IngressStatusFluent.ComponentRoutesNested<A> editComponentRoute(Integer index) {
    if (componentRoutes.size() <= index) throw new RuntimeException("Can't edit componentRoutes. Index exceeds size.");
    return setNewComponentRouteLike(index, buildComponentRoute(index));
  }
  public IngressStatusFluent.ComponentRoutesNested<A> editFirstComponentRoute() {
    if (componentRoutes.size() == 0) throw new RuntimeException("Can't edit first componentRoutes. The list is empty.");
    return setNewComponentRouteLike(0, buildComponentRoute(0));
  }
  public IngressStatusFluent.ComponentRoutesNested<A> editLastComponentRoute() {
    int index = componentRoutes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last componentRoutes. The list is empty.");
    return setNewComponentRouteLike(index, buildComponentRoute(index));
  }
  public IngressStatusFluent.ComponentRoutesNested<A> editMatchingComponentRoute(Predicate<ComponentRouteStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<componentRoutes.size();i++) { 
    if (predicate.test(componentRoutes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching componentRoutes. No match found.");
    return setNewComponentRouteLike(index, buildComponentRoute(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressStatusFluentImpl that = (IngressStatusFluentImpl) o;
    if (componentRoutes != null ? !componentRoutes.equals(that.componentRoutes) :that.componentRoutes != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(componentRoutes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (componentRoutes != null && !componentRoutes.isEmpty()) { sb.append("componentRoutes:"); sb.append(componentRoutes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ComponentRoutesNestedImpl<N> extends ComponentRouteStatusFluentImpl<IngressStatusFluent.ComponentRoutesNested<N>> implements IngressStatusFluent.ComponentRoutesNested<N>,Nested<N>{
    ComponentRoutesNestedImpl(Integer index,ComponentRouteStatus item) {
      this.index = index;
      this.builder = new ComponentRouteStatusBuilder(this, item);
    }
    ComponentRoutesNestedImpl() {
      this.index = -1;
      this.builder = new ComponentRouteStatusBuilder(this);
    }
    ComponentRouteStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) IngressStatusFluentImpl.this.setToComponentRoutes(index,builder.build());
    }
    public N endComponentRoute() {
      return and();
    }
    
  }
  
}