package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageLabelBuilder extends ImageLabelFluentImpl<ImageLabelBuilder> implements VisitableBuilder<ImageLabel,ImageLabelBuilder>{
  public ImageLabelBuilder() {
    this(false);
  }
  public ImageLabelBuilder(Boolean validationEnabled) {
    this(new ImageLabel(), validationEnabled);
  }
  public ImageLabelBuilder(ImageLabelFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageLabelBuilder(ImageLabelFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageLabel(), validationEnabled);
  }
  public ImageLabelBuilder(ImageLabelFluent<?> fluent,ImageLabel instance) {
    this(fluent, instance, false);
  }
  public ImageLabelBuilder(ImageLabelFluent<?> fluent,ImageLabel instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageLabelBuilder(ImageLabel instance) {
    this(instance,false);
  }
  public ImageLabelBuilder(ImageLabel instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageLabelFluent<?> fluent;
  Boolean validationEnabled;
  public ImageLabel build() {
    ImageLabel buildable = new ImageLabel(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}