package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ImageFluent<A extends ImageFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ImageFluent.MetadataNested<A> withNewMetadata();
  public ImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ImageFluent.MetadataNested<A> editMetadata();
  public ImageFluent.MetadataNested<A> editOrNewMetadata();
  public ImageFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageSpec getSpec();
  public ImageSpec buildSpec();
  public A withSpec(ImageSpec spec);
  public Boolean hasSpec();
  public ImageFluent.SpecNested<A> withNewSpec();
  public ImageFluent.SpecNested<A> withNewSpecLike(ImageSpec item);
  public ImageFluent.SpecNested<A> editSpec();
  public ImageFluent.SpecNested<A> editOrNewSpec();
  public ImageFluent.SpecNested<A> editOrNewSpecLike(ImageSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageStatus getStatus();
  public ImageStatus buildStatus();
  public A withStatus(ImageStatus status);
  public Boolean hasStatus();
  public ImageFluent.StatusNested<A> withNewStatus();
  public ImageFluent.StatusNested<A> withNewStatusLike(ImageStatus item);
  public ImageFluent.StatusNested<A> editStatus();
  public ImageFluent.StatusNested<A> editOrNewStatus();
  public ImageFluent.StatusNested<A> editOrNewStatusLike(ImageStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ImageFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ImageSpecFluent<ImageFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ImageStatusFluent<ImageFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}