package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageContentPolicyBuilder extends ImageContentPolicyFluentImpl<ImageContentPolicyBuilder> implements VisitableBuilder<ImageContentPolicy,ImageContentPolicyBuilder>{
  public ImageContentPolicyBuilder() {
    this(false);
  }
  public ImageContentPolicyBuilder(Boolean validationEnabled) {
    this(new ImageContentPolicy(), validationEnabled);
  }
  public ImageContentPolicyBuilder(ImageContentPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageContentPolicyBuilder(ImageContentPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageContentPolicy(), validationEnabled);
  }
  public ImageContentPolicyBuilder(ImageContentPolicyFluent<?> fluent,ImageContentPolicy instance) {
    this(fluent, instance, false);
  }
  public ImageContentPolicyBuilder(ImageContentPolicyFluent<?> fluent,ImageContentPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageContentPolicyBuilder(ImageContentPolicy instance) {
    this(instance,false);
  }
  public ImageContentPolicyBuilder(ImageContentPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageContentPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public ImageContentPolicy build() {
    ImageContentPolicy buildable = new ImageContentPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}