package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitLabIdentityProviderBuilder extends GitLabIdentityProviderFluentImpl<GitLabIdentityProviderBuilder> implements VisitableBuilder<GitLabIdentityProvider,GitLabIdentityProviderBuilder>{
  public GitLabIdentityProviderBuilder() {
    this(false);
  }
  public GitLabIdentityProviderBuilder(Boolean validationEnabled) {
    this(new GitLabIdentityProvider(), validationEnabled);
  }
  public GitLabIdentityProviderBuilder(GitLabIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public GitLabIdentityProviderBuilder(GitLabIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitLabIdentityProvider(), validationEnabled);
  }
  public GitLabIdentityProviderBuilder(GitLabIdentityProviderFluent<?> fluent,GitLabIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public GitLabIdentityProviderBuilder(GitLabIdentityProviderFluent<?> fluent,GitLabIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCa(instance.getCa()); 
    fluent.withClientID(instance.getClientID()); 
    fluent.withClientSecret(instance.getClientSecret()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GitLabIdentityProviderBuilder(GitLabIdentityProvider instance) {
    this(instance,false);
  }
  public GitLabIdentityProviderBuilder(GitLabIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCa(instance.getCa()); 
    this.withClientID(instance.getClientID()); 
    this.withClientSecret(instance.getClientSecret()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GitLabIdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public GitLabIdentityProvider build() {
    GitLabIdentityProvider buildable = new GitLabIdentityProvider(fluent.getCa(),fluent.getClientID(),fluent.getClientSecret(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}