package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GitHubIdentityProviderFluentImpl<A extends GitHubIdentityProviderFluent<A>> extends BaseFluent<A> implements GitHubIdentityProviderFluent<A>{
  public GitHubIdentityProviderFluentImpl() {
  }
  public GitHubIdentityProviderFluentImpl(GitHubIdentityProvider instance) {
    this.withCa(instance.getCa()); 
    this.withClientID(instance.getClientID()); 
    this.withClientSecret(instance.getClientSecret()); 
    this.withHostname(instance.getHostname()); 
    this.withOrganizations(instance.getOrganizations()); 
    this.withTeams(instance.getTeams()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ConfigMapNameReferenceBuilder ca;
  private String clientID;
  private SecretNameReferenceBuilder clientSecret;
  private String hostname;
  private List<String> organizations = new ArrayList<String>();
  private List<String> teams = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCa instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapNameReference getCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public ConfigMapNameReference buildCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public A withCa(ConfigMapNameReference ca) {
    _visitables.get("ca").remove(this.ca);
    if (ca!=null){ this.ca= new ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} else { this.ca = null; _visitables.get("ca").remove(this.ca); } return (A) this;
  }
  public Boolean hasCa() {
    return this.ca != null;
  }
  public A withNewCa(String name) {
    return (A)withCa(new ConfigMapNameReference(name));
  }
  public GitHubIdentityProviderFluent.CaNested<A> withNewCa() {
    return new GitHubIdentityProviderFluentImpl.CaNestedImpl();
  }
  public GitHubIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item) {
    return new GitHubIdentityProviderFluentImpl.CaNestedImpl(item);
  }
  public GitHubIdentityProviderFluent.CaNested<A> editCa() {
    return withNewCaLike(getCa());
  }
  public GitHubIdentityProviderFluent.CaNested<A> editOrNewCa() {
    return withNewCaLike(getCa() != null ? getCa(): new ConfigMapNameReferenceBuilder().build());
  }
  public GitHubIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
    return withNewCaLike(getCa() != null ? getCa(): item);
  }
  public String getClientID() {
    return this.clientID;
  }
  public A withClientID(String clientID) {
    this.clientID=clientID; return (A) this;
  }
  public Boolean hasClientID() {
    return this.clientID != null;
  }
  
  /**
   * This method has been deprecated, please use method buildClientSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretNameReference getClientSecret() {
    return this.clientSecret!=null ?this.clientSecret.build():null;
  }
  public SecretNameReference buildClientSecret() {
    return this.clientSecret!=null ?this.clientSecret.build():null;
  }
  public A withClientSecret(SecretNameReference clientSecret) {
    _visitables.get("clientSecret").remove(this.clientSecret);
    if (clientSecret!=null){ this.clientSecret= new SecretNameReferenceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} else { this.clientSecret = null; _visitables.get("clientSecret").remove(this.clientSecret); } return (A) this;
  }
  public Boolean hasClientSecret() {
    return this.clientSecret != null;
  }
  public A withNewClientSecret(String name) {
    return (A)withClientSecret(new SecretNameReference(name));
  }
  public GitHubIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
    return new GitHubIdentityProviderFluentImpl.ClientSecretNestedImpl();
  }
  public GitHubIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
    return new GitHubIdentityProviderFluentImpl.ClientSecretNestedImpl(item);
  }
  public GitHubIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
    return withNewClientSecretLike(getClientSecret());
  }
  public GitHubIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
    return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new SecretNameReferenceBuilder().build());
  }
  public GitHubIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
    return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
  }
  public String getHostname() {
    return this.hostname;
  }
  public A withHostname(String hostname) {
    this.hostname=hostname; return (A) this;
  }
  public Boolean hasHostname() {
    return this.hostname != null;
  }
  public A addToOrganizations(Integer index,String item) {
    if (this.organizations == null) {this.organizations = new ArrayList<String>();}
    this.organizations.add(index, item);
    return (A)this;
  }
  public A setToOrganizations(Integer index,String item) {
    if (this.organizations == null) {this.organizations = new ArrayList<String>();}
    this.organizations.set(index, item); return (A)this;
  }
  public A addToOrganizations(java.lang.String... items) {
    if (this.organizations == null) {this.organizations = new ArrayList<String>();}
    for (String item : items) {this.organizations.add(item);} return (A)this;
  }
  public A addAllToOrganizations(Collection<String> items) {
    if (this.organizations == null) {this.organizations = new ArrayList<String>();}
    for (String item : items) {this.organizations.add(item);} return (A)this;
  }
  public A removeFromOrganizations(java.lang.String... items) {
    for (String item : items) {if (this.organizations!= null){ this.organizations.remove(item);}} return (A)this;
  }
  public A removeAllFromOrganizations(Collection<String> items) {
    for (String item : items) {if (this.organizations!= null){ this.organizations.remove(item);}} return (A)this;
  }
  public List<String> getOrganizations() {
    return this.organizations;
  }
  public String getOrganization(Integer index) {
    return this.organizations.get(index);
  }
  public String getFirstOrganization() {
    return this.organizations.get(0);
  }
  public String getLastOrganization() {
    return this.organizations.get(organizations.size() - 1);
  }
  public String getMatchingOrganization(Predicate<String> predicate) {
    for (String item: organizations) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingOrganization(Predicate<String> predicate) {
    for (String item: organizations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOrganizations(List<String> organizations) {
    if (organizations != null) {this.organizations = new ArrayList(); for (String item : organizations){this.addToOrganizations(item);}} else { this.organizations = null;} return (A) this;
  }
  public A withOrganizations(java.lang.String... organizations) {
    if (this.organizations != null) {this.organizations.clear();}
    if (organizations != null) {for (String item :organizations){ this.addToOrganizations(item);}} return (A) this;
  }
  public Boolean hasOrganizations() {
    return organizations != null && !organizations.isEmpty();
  }
  public A addToTeams(Integer index,String item) {
    if (this.teams == null) {this.teams = new ArrayList<String>();}
    this.teams.add(index, item);
    return (A)this;
  }
  public A setToTeams(Integer index,String item) {
    if (this.teams == null) {this.teams = new ArrayList<String>();}
    this.teams.set(index, item); return (A)this;
  }
  public A addToTeams(java.lang.String... items) {
    if (this.teams == null) {this.teams = new ArrayList<String>();}
    for (String item : items) {this.teams.add(item);} return (A)this;
  }
  public A addAllToTeams(Collection<String> items) {
    if (this.teams == null) {this.teams = new ArrayList<String>();}
    for (String item : items) {this.teams.add(item);} return (A)this;
  }
  public A removeFromTeams(java.lang.String... items) {
    for (String item : items) {if (this.teams!= null){ this.teams.remove(item);}} return (A)this;
  }
  public A removeAllFromTeams(Collection<String> items) {
    for (String item : items) {if (this.teams!= null){ this.teams.remove(item);}} return (A)this;
  }
  public List<String> getTeams() {
    return this.teams;
  }
  public String getTeam(Integer index) {
    return this.teams.get(index);
  }
  public String getFirstTeam() {
    return this.teams.get(0);
  }
  public String getLastTeam() {
    return this.teams.get(teams.size() - 1);
  }
  public String getMatchingTeam(Predicate<String> predicate) {
    for (String item: teams) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTeam(Predicate<String> predicate) {
    for (String item: teams) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTeams(List<String> teams) {
    if (teams != null) {this.teams = new ArrayList(); for (String item : teams){this.addToTeams(item);}} else { this.teams = null;} return (A) this;
  }
  public A withTeams(java.lang.String... teams) {
    if (this.teams != null) {this.teams.clear();}
    if (teams != null) {for (String item :teams){ this.addToTeams(item);}} return (A) this;
  }
  public Boolean hasTeams() {
    return teams != null && !teams.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GitHubIdentityProviderFluentImpl that = (GitHubIdentityProviderFluentImpl) o;
    if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
    if (clientID != null ? !clientID.equals(that.clientID) :that.clientID != null) return false;
    if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
    if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
    if (organizations != null ? !organizations.equals(that.organizations) :that.organizations != null) return false;
    if (teams != null ? !teams.equals(that.teams) :that.teams != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ca,  clientID,  clientSecret,  hostname,  organizations,  teams,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (clientID != null) { sb.append("clientID:"); sb.append(clientID + ","); }
    if (clientSecret != null) { sb.append("clientSecret:"); sb.append(clientSecret + ","); }
    if (hostname != null) { sb.append("hostname:"); sb.append(hostname + ","); }
    if (organizations != null && !organizations.isEmpty()) { sb.append("organizations:"); sb.append(organizations + ","); }
    if (teams != null && !teams.isEmpty()) { sb.append("teams:"); sb.append(teams + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CaNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<GitHubIdentityProviderFluent.CaNested<N>> implements GitHubIdentityProviderFluent.CaNested<N>,Nested<N>{
    CaNestedImpl(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    CaNestedImpl() {
      this.builder = new ConfigMapNameReferenceBuilder(this);
    }
    ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) GitHubIdentityProviderFluentImpl.this.withCa(builder.build());
    }
    public N endCa() {
      return and();
    }
    
  }
  class ClientSecretNestedImpl<N> extends SecretNameReferenceFluentImpl<GitHubIdentityProviderFluent.ClientSecretNested<N>> implements GitHubIdentityProviderFluent.ClientSecretNested<N>,Nested<N>{
    ClientSecretNestedImpl(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    ClientSecretNestedImpl() {
      this.builder = new SecretNameReferenceBuilder(this);
    }
    SecretNameReferenceBuilder builder;
    public N and() {
      return (N) GitHubIdentityProviderFluentImpl.this.withClientSecret(builder.build());
    }
    public N endClientSecret() {
      return and();
    }
    
  }
  
}