package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AuditFluentImpl<A extends AuditFluent<A>> extends BaseFluent<A> implements AuditFluent<A>{
  public AuditFluentImpl() {
  }
  public AuditFluentImpl(Audit instance) {
    this.withCustomRules(instance.getCustomRules()); 
    this.withProfile(instance.getProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<AuditCustomRuleBuilder> customRules = new ArrayList<AuditCustomRuleBuilder>();
  private String profile;
  private Map<String,Object> additionalProperties;
  public A addToCustomRules(Integer index,AuditCustomRule item) {
    if (this.customRules == null) {this.customRules = new ArrayList<AuditCustomRuleBuilder>();}
    AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);_visitables.get("customRules").add(index >= 0 ? index : _visitables.get("customRules").size(), builder);this.customRules.add(index >= 0 ? index : customRules.size(), builder); return (A)this;
  }
  public A setToCustomRules(Integer index,AuditCustomRule item) {
    if (this.customRules == null) {this.customRules = new ArrayList<AuditCustomRuleBuilder>();}
    AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("customRules").size()) { _visitables.get("customRules").add(builder); } else { _visitables.get("customRules").set(index, builder);}
    if (index < 0 || index >= customRules.size()) { customRules.add(builder); } else { customRules.set(index, builder);}
     return (A)this;
  }
  public A addToCustomRules(io.fabric8.openshift.api.model.config.v1.AuditCustomRule... items) {
    if (this.customRules == null) {this.customRules = new ArrayList<AuditCustomRuleBuilder>();}
    for (AuditCustomRule item : items) {AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);_visitables.get("customRules").add(builder);this.customRules.add(builder);} return (A)this;
  }
  public A addAllToCustomRules(Collection<AuditCustomRule> items) {
    if (this.customRules == null) {this.customRules = new ArrayList<AuditCustomRuleBuilder>();}
    for (AuditCustomRule item : items) {AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);_visitables.get("customRules").add(builder);this.customRules.add(builder);} return (A)this;
  }
  public A removeFromCustomRules(io.fabric8.openshift.api.model.config.v1.AuditCustomRule... items) {
    for (AuditCustomRule item : items) {AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);_visitables.get("customRules").remove(builder);if (this.customRules != null) {this.customRules.remove(builder);}} return (A)this;
  }
  public A removeAllFromCustomRules(Collection<AuditCustomRule> items) {
    for (AuditCustomRule item : items) {AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);_visitables.get("customRules").remove(builder);if (this.customRules != null) {this.customRules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCustomRules(Predicate<AuditCustomRuleBuilder> predicate) {
    if (customRules == null) return (A) this;
    final Iterator<AuditCustomRuleBuilder> each = customRules.iterator();
    final List visitables = _visitables.get("customRules");
    while (each.hasNext()) {
      AuditCustomRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildCustomRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AuditCustomRule> getCustomRules() {
    return customRules != null ? build(customRules) : null;
  }
  public List<AuditCustomRule> buildCustomRules() {
    return customRules != null ? build(customRules) : null;
  }
  public AuditCustomRule buildCustomRule(Integer index) {
    return this.customRules.get(index).build();
  }
  public AuditCustomRule buildFirstCustomRule() {
    return this.customRules.get(0).build();
  }
  public AuditCustomRule buildLastCustomRule() {
    return this.customRules.get(customRules.size() - 1).build();
  }
  public AuditCustomRule buildMatchingCustomRule(Predicate<AuditCustomRuleBuilder> predicate) {
    for (AuditCustomRuleBuilder item: customRules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCustomRule(Predicate<AuditCustomRuleBuilder> predicate) {
    for (AuditCustomRuleBuilder item: customRules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCustomRules(List<AuditCustomRule> customRules) {
    if (this.customRules != null) { _visitables.get("customRules").removeAll(this.customRules);}
    if (customRules != null) {this.customRules = new ArrayList(); for (AuditCustomRule item : customRules){this.addToCustomRules(item);}} else { this.customRules = null;} return (A) this;
  }
  public A withCustomRules(io.fabric8.openshift.api.model.config.v1.AuditCustomRule... customRules) {
    if (this.customRules != null) {this.customRules.clear();}
    if (customRules != null) {for (AuditCustomRule item :customRules){ this.addToCustomRules(item);}} return (A) this;
  }
  public Boolean hasCustomRules() {
    return customRules != null && !customRules.isEmpty();
  }
  public A addNewCustomRule(String group,String profile) {
    return (A)addToCustomRules(new AuditCustomRule(group, profile));
  }
  public AuditFluent.CustomRulesNested<A> addNewCustomRule() {
    return new AuditFluentImpl.CustomRulesNestedImpl();
  }
  public AuditFluent.CustomRulesNested<A> addNewCustomRuleLike(AuditCustomRule item) {
    return new AuditFluentImpl.CustomRulesNestedImpl(-1, item);
  }
  public AuditFluent.CustomRulesNested<A> setNewCustomRuleLike(Integer index,AuditCustomRule item) {
    return new AuditFluentImpl.CustomRulesNestedImpl(index, item);
  }
  public AuditFluent.CustomRulesNested<A> editCustomRule(Integer index) {
    if (customRules.size() <= index) throw new RuntimeException("Can't edit customRules. Index exceeds size.");
    return setNewCustomRuleLike(index, buildCustomRule(index));
  }
  public AuditFluent.CustomRulesNested<A> editFirstCustomRule() {
    if (customRules.size() == 0) throw new RuntimeException("Can't edit first customRules. The list is empty.");
    return setNewCustomRuleLike(0, buildCustomRule(0));
  }
  public AuditFluent.CustomRulesNested<A> editLastCustomRule() {
    int index = customRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last customRules. The list is empty.");
    return setNewCustomRuleLike(index, buildCustomRule(index));
  }
  public AuditFluent.CustomRulesNested<A> editMatchingCustomRule(Predicate<AuditCustomRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<customRules.size();i++) { 
    if (predicate.test(customRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching customRules. No match found.");
    return setNewCustomRuleLike(index, buildCustomRule(index));
  }
  public String getProfile() {
    return this.profile;
  }
  public A withProfile(String profile) {
    this.profile=profile; return (A) this;
  }
  public Boolean hasProfile() {
    return this.profile != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuditFluentImpl that = (AuditFluentImpl) o;
    if (customRules != null ? !customRules.equals(that.customRules) :that.customRules != null) return false;
    if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(customRules,  profile,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (customRules != null && !customRules.isEmpty()) { sb.append("customRules:"); sb.append(customRules + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CustomRulesNestedImpl<N> extends AuditCustomRuleFluentImpl<AuditFluent.CustomRulesNested<N>> implements AuditFluent.CustomRulesNested<N>,Nested<N>{
    CustomRulesNestedImpl(Integer index,AuditCustomRule item) {
      this.index = index;
      this.builder = new AuditCustomRuleBuilder(this, item);
    }
    CustomRulesNestedImpl() {
      this.index = -1;
      this.builder = new AuditCustomRuleBuilder(this);
    }
    AuditCustomRuleBuilder builder;
    Integer index;
    public N and() {
      return (N) AuditFluentImpl.this.setToCustomRules(index,builder.build());
    }
    public N endCustomRule() {
      return and();
    }
    
  }
  
}