package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SchedulerSpecBuilder extends SchedulerSpecFluentImpl<SchedulerSpecBuilder> implements VisitableBuilder<SchedulerSpec,SchedulerSpecBuilder>{
  public SchedulerSpecBuilder() {
    this(false);
  }
  public SchedulerSpecBuilder(Boolean validationEnabled) {
    this(new SchedulerSpec(), validationEnabled);
  }
  public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SchedulerSpec(), validationEnabled);
  }
  public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent,SchedulerSpec instance) {
    this(fluent, instance, false);
  }
  public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent,SchedulerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDefaultNodeSelector(instance.getDefaultNodeSelector()); 
    fluent.withMastersSchedulable(instance.getMastersSchedulable()); 
    fluent.withPolicy(instance.getPolicy()); 
    fluent.withProfile(instance.getProfile()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SchedulerSpecBuilder(SchedulerSpec instance) {
    this(instance,false);
  }
  public SchedulerSpecBuilder(SchedulerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDefaultNodeSelector(instance.getDefaultNodeSelector()); 
    this.withMastersSchedulable(instance.getMastersSchedulable()); 
    this.withPolicy(instance.getPolicy()); 
    this.withProfile(instance.getProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SchedulerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SchedulerSpec build() {
    SchedulerSpec buildable = new SchedulerSpec(fluent.getDefaultNodeSelector(),fluent.getMastersSchedulable(),fluent.getPolicy(),fluent.getProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}