package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OvirtPlatformSpecBuilder extends OvirtPlatformSpecFluentImpl<OvirtPlatformSpecBuilder> implements VisitableBuilder<OvirtPlatformSpec,OvirtPlatformSpecBuilder>{
  public OvirtPlatformSpecBuilder() {
    this(false);
  }
  public OvirtPlatformSpecBuilder(Boolean validationEnabled) {
    this(new OvirtPlatformSpec(), validationEnabled);
  }
  public OvirtPlatformSpecBuilder(OvirtPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public OvirtPlatformSpecBuilder(OvirtPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OvirtPlatformSpec(), validationEnabled);
  }
  public OvirtPlatformSpecBuilder(OvirtPlatformSpecFluent<?> fluent,OvirtPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public OvirtPlatformSpecBuilder(OvirtPlatformSpecFluent<?> fluent,OvirtPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OvirtPlatformSpecBuilder(OvirtPlatformSpec instance) {
    this(instance,false);
  }
  public OvirtPlatformSpecBuilder(OvirtPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OvirtPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public OvirtPlatformSpec build() {
    OvirtPlatformSpec buildable = new OvirtPlatformSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}