package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InfrastructureBuilder extends InfrastructureFluentImpl<InfrastructureBuilder> implements VisitableBuilder<Infrastructure,InfrastructureBuilder>{
  public InfrastructureBuilder() {
    this(false);
  }
  public InfrastructureBuilder(Boolean validationEnabled) {
    this(new Infrastructure(), validationEnabled);
  }
  public InfrastructureBuilder(InfrastructureFluent<?> fluent) {
    this(fluent, false);
  }
  public InfrastructureBuilder(InfrastructureFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Infrastructure(), validationEnabled);
  }
  public InfrastructureBuilder(InfrastructureFluent<?> fluent,Infrastructure instance) {
    this(fluent, instance, false);
  }
  public InfrastructureBuilder(InfrastructureFluent<?> fluent,Infrastructure instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public InfrastructureBuilder(Infrastructure instance) {
    this(instance,false);
  }
  public InfrastructureBuilder(Infrastructure instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  InfrastructureFluent<?> fluent;
  Boolean validationEnabled;
  public Infrastructure build() {
    Infrastructure buildable = new Infrastructure(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}