package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServerListBuilder extends APIServerListFluentImpl<APIServerListBuilder> implements VisitableBuilder<APIServerList,APIServerListBuilder>{
  public APIServerListBuilder() {
    this(false);
  }
  public APIServerListBuilder(Boolean validationEnabled) {
    this(new APIServerList(), validationEnabled);
  }
  public APIServerListBuilder(APIServerListFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerListBuilder(APIServerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIServerList(), validationEnabled);
  }
  public APIServerListBuilder(APIServerListFluent<?> fluent,APIServerList instance) {
    this(fluent, instance, false);
  }
  public APIServerListBuilder(APIServerListFluent<?> fluent,APIServerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServerListBuilder(APIServerList instance) {
    this(instance,false);
  }
  public APIServerListBuilder(APIServerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  APIServerListFluent<?> fluent;
  Boolean validationEnabled;
  public APIServerList build() {
    APIServerList buildable = new APIServerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}