package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface RequiredHSTSPolicyFluent<A extends RequiredHSTSPolicyFluent<A>> extends Fluent<A>{
  public A addToDomainPatterns(Integer index,String item);
  public A setToDomainPatterns(Integer index,String item);
  public A addToDomainPatterns(java.lang.String... items);
  public A addAllToDomainPatterns(Collection<String> items);
  public A removeFromDomainPatterns(java.lang.String... items);
  public A removeAllFromDomainPatterns(Collection<String> items);
  public List<String> getDomainPatterns();
  public String getDomainPattern(Integer index);
  public String getFirstDomainPattern();
  public String getLastDomainPattern();
  public String getMatchingDomainPattern(Predicate<String> predicate);
  public Boolean hasMatchingDomainPattern(Predicate<String> predicate);
  public A withDomainPatterns(List<String> domainPatterns);
  public A withDomainPatterns(java.lang.String... domainPatterns);
  public Boolean hasDomainPatterns();
  public String getIncludeSubDomainsPolicy();
  public A withIncludeSubDomainsPolicy(String includeSubDomainsPolicy);
  public Boolean hasIncludeSubDomainsPolicy();
  
  /**
   * This method has been deprecated, please use method buildMaxAge instead.
   * @return The buildable object.
   */
  @Deprecated
  public MaxAgePolicy getMaxAge();
  public MaxAgePolicy buildMaxAge();
  public A withMaxAge(MaxAgePolicy maxAge);
  public Boolean hasMaxAge();
  public A withNewMaxAge(Integer largestMaxAge,Integer smallestMaxAge);
  public RequiredHSTSPolicyFluent.MaxAgeNested<A> withNewMaxAge();
  public RequiredHSTSPolicyFluent.MaxAgeNested<A> withNewMaxAgeLike(MaxAgePolicy item);
  public RequiredHSTSPolicyFluent.MaxAgeNested<A> editMaxAge();
  public RequiredHSTSPolicyFluent.MaxAgeNested<A> editOrNewMaxAge();
  public RequiredHSTSPolicyFluent.MaxAgeNested<A> editOrNewMaxAgeLike(MaxAgePolicy item);
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getNamespaceSelector();
  public LabelSelector buildNamespaceSelector();
  public A withNamespaceSelector(LabelSelector namespaceSelector);
  public Boolean hasNamespaceSelector();
  public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> withNewNamespaceSelector();
  public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item);
  public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> editNamespaceSelector();
  public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector();
  public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item);
  public String getPreloadPolicy();
  public A withPreloadPolicy(String preloadPolicy);
  public Boolean hasPreloadPolicy();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MaxAgeNested<N> extends Nested<N>,MaxAgePolicyFluent<RequiredHSTSPolicyFluent.MaxAgeNested<N>>{
    public N and();
    public N endMaxAge();
    
  }
  public interface NamespaceSelectorNested<N> extends Nested<N>,LabelSelectorFluent<RequiredHSTSPolicyFluent.NamespaceSelectorNested<N>>{
    public N and();
    public N endNamespaceSelector();
    
  }
  
}