package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MaxAgePolicyBuilder extends MaxAgePolicyFluentImpl<MaxAgePolicyBuilder> implements VisitableBuilder<MaxAgePolicy,MaxAgePolicyBuilder>{
  public MaxAgePolicyBuilder() {
    this(false);
  }
  public MaxAgePolicyBuilder(Boolean validationEnabled) {
    this(new MaxAgePolicy(), validationEnabled);
  }
  public MaxAgePolicyBuilder(MaxAgePolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public MaxAgePolicyBuilder(MaxAgePolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MaxAgePolicy(), validationEnabled);
  }
  public MaxAgePolicyBuilder(MaxAgePolicyFluent<?> fluent,MaxAgePolicy instance) {
    this(fluent, instance, false);
  }
  public MaxAgePolicyBuilder(MaxAgePolicyFluent<?> fluent,MaxAgePolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLargestMaxAge(instance.getLargestMaxAge()); 
    fluent.withSmallestMaxAge(instance.getSmallestMaxAge()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MaxAgePolicyBuilder(MaxAgePolicy instance) {
    this(instance,false);
  }
  public MaxAgePolicyBuilder(MaxAgePolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLargestMaxAge(instance.getLargestMaxAge()); 
    this.withSmallestMaxAge(instance.getSmallestMaxAge()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MaxAgePolicyFluent<?> fluent;
  Boolean validationEnabled;
  public MaxAgePolicy build() {
    MaxAgePolicy buildable = new MaxAgePolicy(fluent.getLargestMaxAge(),fluent.getSmallestMaxAge());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}