package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LDAPIdentityProviderBuilder extends LDAPIdentityProviderFluentImpl<LDAPIdentityProviderBuilder> implements VisitableBuilder<LDAPIdentityProvider,LDAPIdentityProviderBuilder>{
  public LDAPIdentityProviderBuilder() {
    this(false);
  }
  public LDAPIdentityProviderBuilder(Boolean validationEnabled) {
    this(new LDAPIdentityProvider(), validationEnabled);
  }
  public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LDAPIdentityProvider(), validationEnabled);
  }
  public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent,LDAPIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent,LDAPIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAttributes(instance.getAttributes()); 
    fluent.withBindDN(instance.getBindDN()); 
    fluent.withBindPassword(instance.getBindPassword()); 
    fluent.withCa(instance.getCa()); 
    fluent.withInsecure(instance.getInsecure()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LDAPIdentityProviderBuilder(LDAPIdentityProvider instance) {
    this(instance,false);
  }
  public LDAPIdentityProviderBuilder(LDAPIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAttributes(instance.getAttributes()); 
    this.withBindDN(instance.getBindDN()); 
    this.withBindPassword(instance.getBindPassword()); 
    this.withCa(instance.getCa()); 
    this.withInsecure(instance.getInsecure()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  LDAPIdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public LDAPIdentityProvider build() {
    LDAPIdentityProvider buildable = new LDAPIdentityProvider(fluent.getAttributes(),fluent.getBindDN(),fluent.getBindPassword(),fluent.getCa(),fluent.getInsecure(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}